<?php
/******************************************************************************************
 * Copyright (C) Smackcoders. - All Rights Reserved under Smackcoders Proprietary License
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 * You can contact Smackcoders at email address info@smackcoders.com.
 *******************************************************************************************/

namespace Smackcoders\WCSV;

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

class WooCommerceCoreImport {
    private static $woocommerce_core_instance = null,$media_instance;

    public static function getInstance() {
		if (WooCommerceCoreImport::$woocommerce_core_instance == null) {
			WooCommerceCoreImport::$woocommerce_core_instance = new WooCommerceCoreImport;
			WooCommerceCoreImport::$media_instance = new MediaHandling();
			return WooCommerceCoreImport::$woocommerce_core_instance;
		}
		return WooCommerceCoreImport::$woocommerce_core_instance;
    }

    public function woocommerce_variations_import($data_array , $mode , $check , $unikey ,$unikey_name, $line_number, $variation_count,$update_based_on) {				
		global $wpdb;
		$log_table_name = $wpdb->prefix ."import_detail_log";
		$core_instance = CoreFieldsImport::getInstance();
		$helpers_instance = ImportHelpers::getInstance();
		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$skipped_count = $updated_row_counts['skipped'];
       
		$productInfo = '';
		$returnArr = array('MODE' => $mode , 'ID' => '');
		$product_id = isset($data_array['PRODUCTID']) ? $data_array['PRODUCTID'] : '';
		$parent_sku = isset($data_array['PARENTSKU']) ? $data_array['PARENTSKU'] : '';
		$variation_id =  isset($data_array['VARIATIONID']) ? $data_array['VARIATIONID'] : '';
		$variation_sku = isset($data_array['VARIATIONSKU']) ? $data_array['VARIATIONSKU'] : '';		
		if($product_id != '' && ($variation_sku == '' || $variation_id == '')) {
			if($variation_sku != ''){
				$variation_condition = 'update_using_variation_sku';
			}
			else if($variation_id != ''){
				$variation_condition = 'update_using_variation_id';
			}
			else{
				$variation_condition = 'insert_using_product_id';
			}

		} 		
		elseif($parent_sku != '') {			
			$get_parent_product_id = $wpdb->get_results("select id from {$wpdb->prefix}posts where post_status != 'trash' and post_type = 'product' and id in (select post_id from {$wpdb->prefix}postmeta where meta_value = '$parent_sku')");									
			$count = count( $get_parent_product_id );
			$key = 0;
			if ( ! empty( $get_parent_product_id ) ) {				
				$product_id = $get_parent_product_id[$key]->id;
				//Check whether the product is variable type
				$term_details = wp_get_object_terms($product_id,'product_type');
				if((!empty($term_details)) && ($term_details[0]->name != 'variable')){
					
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped,Product is not variable in type.";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					return array('MODE' => $mode,'ID' => '');					
				}
			} else {
				$product_id = '';
				$core_instance->detailed_log[$line_number]['Message'] = "Skipped,Product is not available.";
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					return array('MODE' => $mode,'ID' => '');
			}			
			if($mode == 'Insert'){
				$variation_condition = 'insert_using_product_sku';
			}
			if($variation_sku != '' && $mode == 'Update'){
				$variation_condition = 'update_using_variation_sku';
			}
			if($variation_id != ''){
				$variation_condition = 'update_using_variation_id';
			}
		}
		elseif($parent_sku == '' && ($variation_sku != '' || $variation_id != '')){
			if($variation_sku != ''){
				$variation_condition = 'update_using_variation_sku';
			}
			if($variation_id != ''){
				$variation_condition = 'update_using_variation_id';
			}
		}

		if($variation_sku != '' && $variation_id != ''){
			update_post_meta($variation_id, '_sku', $variation_sku);
		}
        
		if($product_id != '') {
			$is_exist_product = $wpdb->get_results($wpdb->prepare("select * from {$wpdb->prefix}posts where ID = %d", $product_id));
			if(!empty($is_exist_product) && $is_exist_product[0]->ID == $product_id) {
				$productInfo = $is_exist_product[0];
			} else {
				#return $returnArr;
			}
		}			
	
		if(isset($variation_condition)){
		switch ($variation_condition) {
			case 'update_using_variation_id_and_sku':
				
				$get_variation_data = $wpdb->get_results( $wpdb->prepare( "select DISTINCT pm.post_id from {$wpdb->prefix}posts p join {$wpdb->prefix}postmeta pm on p.ID = pm.post_id where p.ID = %d and p.post_type = %s and pm.meta_value = %s", $variation_id, 'product_variation', $variation_sku ) );

				if ( ! empty( $get_variation_data ) && $get_variation_data[0]->post_id == $variation_id ) {
					$returnArr = $this->importVariationData( $product_id, $variation_id, 'update_using_variation_id_and_sku' ,$unikey  , $unikey_name, $line_number, $variation_count,$get_variation_data);
				} else {
					if($update_based_on == 'skip'){
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to'$check'not present already <br>";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
						$returnArr['Mode'] = $mode;
						return $returnArr;
						// $get_variation_data = [];
					}
					else{
						$returnArr = $this->importVariationData( $product_id, $variation_id, 'default' ,$unikey , $unikey_name, $line_number, $variation_count, $productInfo);
					}
					
				}
				break;
			case 'update_using_variation_id':
				
				$get_variation_data = $wpdb->get_results( $wpdb->prepare( "select * from {$wpdb->prefix}posts where ID = %d and post_type = %s", $variation_id, 'product_variation' ) );
				if ( ! empty( $get_variation_data ) && $get_variation_data[0]->ID == $variation_id ) {
					$returnArr = $this->importVariationData( $product_id, $variation_id, 'update_using_variation_id' ,$unikey  , $unikey_name, $line_number, $variation_count, $get_variation_data);
				} else {
					if($update_based_on == 'skip'){
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to '$check' not present already <br>";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
						$returnArr['Mode'] = $mode;
						return $returnArr;
						// $get_variation_data = [];
					}
					else{
						$returnArr = $this->importVariationData( $product_id, $variation_id, 'default',$unikey , $unikey_name, $line_number, $variation_count, $productInfo );
					}
					
				}
				break;
			case 'update_using_variation_sku':								
				$variation_data = $wpdb->get_results("select post_id from {$wpdb->prefix}postmeta where meta_value = '$variation_sku' and post_id in (select id from {$wpdb->prefix}posts where post_type = 'product_variation' and post_status != 'trash' and post_parent = $product_id)");
				$variation_id = !empty($variation_data) ? $variation_data[0]->post_id : "";								
				if($variation_id)
				$get_variation_data = $wpdb->get_results( $wpdb->prepare( "select * from {$wpdb->prefix}posts where ID = %d and post_type = %s", $variation_id, 'product_variation' ) );				
				else
				$get_variation_data = [];
				if ( ! empty( $get_variation_data ) && $get_variation_data[0]->ID == $variation_id) {
					$returnArr = $this->importVariationData( $product_id,$variation_id, 'update_using_variation_sku' ,$unikey  , $unikey_name, $line_number, $variation_count,$get_variation_data);
				} else {
					if($update_based_on == 'skip'){
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to '$check 'not present already <br>";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
						$returnArr['Mode'] = $mode;
						return $returnArr;
						// $get_variation_data = [];
					}
					else{
						$returnArr = $this->importVariationData( $product_id, $variation_id, 'default' ,$unikey , $unikey_name, $line_number, $variation_count, $productInfo);
					}
				}
				break;
			case 'insert_using_product_id':
				if($update_based_on == 'skip'){
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to '$check ' not present already <br>";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					$returnArr['Mode'] = $mode;
					return $returnArr;
					// $get_variation_data = [];
				}
				else{
					$returnArr = $this->importVariationData( $product_id, $variation_id, 'insert_using_product_id',$unikey , $unikey_name, $line_number, $variation_count,  $productInfo);
				}
				break;
			case 'insert_using_product_sku':
				if($update_based_on == 'skip'){
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to '$check' not present already <br>";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					$returnArr['Mode'] = $mode;
					return $returnArr;
					// $get_variation_data = [];
				}else{
					$returnArr = $this->importVariationData( $product_id, $variation_id, 'insert_using_product_sku',$unikey ,$unikey_name, $line_number, $variation_count, $productInfo );
				}
				break;
			default:
				if($update_based_on == 'skip'){
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to '$check ' not present already <br>";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					$returnArr['Mode'] = $mode;
					return $returnArr;
					// $get_variation_data = [];
				}
				else{
					$returnArr = $this->importVariationData( $product_id, $variation_id, 'default',$unikey  ,$unikey_name, $line_number, $variation_count, $productInfo);
				}
				break;
		}
	}
		return $returnArr;
	}

	public function importVariationData ($product_id, $variation_id, $type,$unikey , $unikey_name, $line_number, $variation_count, $exist_variation_data = array()) {		
		global $wpdb;
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;
		$log_table_name = $wpdb->prefix ."import_detail_log";

		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];
		if($type == 'default' || $type == 'insert_using_product_id' || $type == 'insert_using_product_sku') {
			
			$get_count_of_variations = $wpdb->get_results( $wpdb->prepare( "select count(*) as variations_count from {$wpdb->prefix}posts where post_parent = %d and post_type = %s", $product_id, 'product_variation' ) );
			$variations_count = $get_count_of_variations[0]->variations_count;
			$menu_order_count = 0;
			if ($variations_count == 0) {
				$variations_count = '';
				$menu_order= 0 ;
			} else {
				$variations_count = $variations_count + 1;
				$menu_order_count = $variations_count - 1;
				$variations_count = '-' . $variations_count;
			}
			$get_variation_data = $wpdb->get_results($wpdb->prepare("select * from {$wpdb->prefix}posts where ID = %d", $product_id));
			foreach($get_variation_data as $key => $val) {
				
				if($product_id == $val->ID){

					$variation_data = array();
					$variation_data['post_title'] = $val->post_title ;
					$variation_data['post_date'] = $val->post_date;
					$variation_data['post_type'] = 'product_variation';
					$variation_data['post_status'] = 'publish';
					$variation_data['comment_status'] = 'closed';
					$variation_data['ping_status'] = 'closed';
					$variation_data['menu_order'] = $menu_order_count;
					$variation_data['post_name'] = 'product-' . $val->ID . '-variation' . $variations_count;
					$variation_data['post_parent'] = $val->ID;
					
				}
			}
			//$variation_data=isset($variation_data)?$variation_data:'';
			$variationid = wp_insert_post($variation_data);					
			if(empty($variation_count)){
				$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Variation ID: ' . $variationid;
				$core_instance->detailed_log[$line_number]['id'] = $variationid;
				$core_instance->detailed_log[$line_number]['webLink'] = get_permalink( $variationid );
				$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
			}
			else{				
				$parent_id = $wpdb->get_var( "SELECT post_parent FROM {$wpdb->prefix}posts WHERE id = '$variationid' " );								
				$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product ID: ' . $parent_id . '   Inserted Variation ID: ' . $variationid;
				$core_instance->detailed_log[$line_number]['Sku'] = $variation_count[0];			
				$core_instance->detailed_log[$line_number]['webLink'] = get_permalink( $variationid );
				$core_instance->detailed_log[$line_number]['state'] = 'Inserted';			
			}
			$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");		
			$returnArr = array( 'ID' => $variationid, 'MODE' => 'Inserted' );
			return $returnArr;
		} elseif ($type == 'update_using_variation_id' || $type == 'update_using_variation_sku' || $type == 'update_using_variation_id_and_sku') {
			//Not needed only variation meta are updated while update
			/*foreach($exist_variation_data as $key => $val) {
				if($variation_id == $val->ID){
					$variation_data['ID'] = $val->ID;
					$variation_data['post_title'] = $val->post_title;
					$variation_data['post_status'] = 'publish';
					$variation_data['comment_status'] = 'open';
					$variation_data['ping_status'] = 'open';
					$variation_data['post_name'] = 'product-' . $val->ID . '-variation' . $variations_count;
					$variation_data['post_parent'] = $val->post_parent;
					$variation_data['post_type'] = 'product_variation';
					$variation_data['menu_order'] = $val->menu_order;
				}
			}

			wp_update_post($variation_data);*/

			$core_instance->detailed_log[$line_number]['Message'] = 'Updated Variation ID: ' . $variation_id;
			$core_instance->detailed_log[$line_number]['webLink'] = get_permalink( $variation_id );
			$core_instance->detailed_log[$line_number]['state'] = 'Updated';
			$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");

			$returnArr = array( 'ID' => $variation_id, 'MODE' => 'Updated');			
			return $returnArr;
		}
	}
	public function woocommerce_orders_new_import($data_array , $mode , $check , $unikey , $unikey_name, $line_number,$order_meta_data,$update_based_on) {
		global $wpdb;
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;

		$log_table_name = $wpdb->prefix ."import_detail_log";

		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];
	if (class_exists('WC_Order')) {
		// Create a new order instance
		if ($mode == 'Insert') {
			$order = wc_create_order();
			$order_id = $order->save();
			$mode_of_affect = 'Inserted';
			if(is_wp_error($order_id) || $order_id == '') {
				$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Order. " . $order_id->get_error_message();
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode, 'ERROR_MSG' => $order_id->get_error_message());
			}
			$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Order ID: ' . $order_id;
			$core_instance->detailed_log[$line_number]['id'] = $order_id;
			$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $order_id, true );
			$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
			$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
		}
		elseif ($mode == 'Update') {
			$order_id=$data_array['ORDERID'];
			$update_query = "select ID from {$wpdb->prefix}posts where ID = $order_id";
			$ID_result = $wpdb->get_results($update_query);
			if (is_array($ID_result) && !empty($ID_result)) {
				$retID = $ID_result[0]->ID;
				$data_array['ID'] = $retID;
				// wp_update_post($data_array);
				$mode_of_affect = 'Updated';

				$core_instance->detailed_log[$line_number]['Message'] = 'Updated Order ID: ' . $retID;
				$core_instance->detailed_log[$line_number]['id'] = $retID;
				$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
				$core_instance->detailed_log[$line_number]['state'] = 'Updated';
				$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");	
			} else{
							
				$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode);
			}
			$order=wc_get_order($data_array['ORDERID']);
		}else{
				$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode);
				
		}	
	}
	$item_name = $order_meta_data['item_name'];
	$item_qty = $order_meta_data['item_qty'];
	$products = explode(',', $item_name);
	$quantities = explode(',', $item_qty);
	if ($mode == 'Insert') {
		$queried_titles = array();
		foreach($products as $products_value ){
			$title = ltrim($products_value);
			if (is_numeric($products_value)) {
				$product_ids = $products_value;
			} 
			elseif (!in_array($title, $queried_titles)) {
				$product_ids[] = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title ='$title' AND post_type='product' AND post_status='publish'");
				if ($product_ids !== null) {
					$queried_titles[] = $title;
				}
			}
		}
		for($i = 0 ; $i < count($product_ids) ; $i++){
		$my_product = wc_get_product($product_ids[$i]);
		if(!empty($my_product)){
			if ($my_product->is_type('variable')) {
				$variations = $my_product->get_children();
				for ($i = 0; $i < count($variations); $i++) {
					$quantity  = !empty($quantities[$i]) ? $quantities[$i] : '' ;
					$variation = !empty($variations[$i]) ? wc_get_product($variations[$i]) : '';
					if (!empty($variation) && $variation->exists()) {
						$order->add_product($variation, $quantity);
					}
				}
			}else{
				$quantity = !empty($quantities[$i]) ? $quantities[$i] : '' ;
				if(isset($product_ids[$i]) && !empty($product_ids[$i])){
					$order->add_product(wc_get_product($product_ids[$i]), $quantity);
				}
			}
		}
		}
	}
    // Set customer information
	$customer_user = $order_meta_data['customer_user'];
	if(is_numeric($customer_user)){
		$customer_user_id = $customer_user;
	}
	else{
		$email = $customer_user;
		$customer_user_id = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}users WHERE user_email='$email'");
	}
	$customer_note = $data_array['customer_note'];

    // Replace with the customer's user ID
    $order->set_customer_id($customer_user_id);
	$billing_first_name = isset($order_meta_data['billing_first_name']) ? $order_meta_data['billing_first_name'] : '';
	$billing_last_name = isset($order_meta_data['billing_last_name']) ? $order_meta_data['billing_last_name'] : '';
	$billing_company = isset($order_meta_data['billing_company']) ? $order_meta_data['billing_company'] : '';
	$billing_address_1 = isset($order_meta_data['billing_address_1']) ? $order_meta_data['billing_address_1'] : '';
	$billing_address_2 = isset($order_meta_data['billing_address_2']) ? $order_meta_data['billing_address_2'] : '';
	$billing_city = isset($order_meta_data['billing_city']) ? $order_meta_data['billing_city'] : '';
	$billing_postcode = isset($order_meta_data['billing_postcode']) ? $order_meta_data['billing_postcode'] : '';
	$billing_country = isset($order_meta_data['billing_country']) ? $order_meta_data['billing_country'] : '';
	$billing_phone = isset($order_meta_data['billing_phone']) ? $order_meta_data['billing_phone'] : '';
	$billing_email = isset($order_meta_data['billing_email']) ? $order_meta_data['billing_email'] : '';
	$billing_state = isset($order_meta_data['billing_state']) ? $order_meta_data['billing_state'] : '';
	$shipping_first_name = isset($order_meta_data['shipping_first_name']) ? $order_meta_data['shipping_first_name'] : '';
	$shipping_last_name = isset($order_meta_data['shipping_last_name']) ? $order_meta_data['shipping_last_name'] : '';
	$shipping_company = isset($order_meta_data['shipping_company']) ? $order_meta_data['shipping_company'] : '';
	$shipping_address_1 = isset($order_meta_data['shipping_address_1']) ? $order_meta_data['shipping_address_1'] : '';
	$shipping_address_2 = isset($order_meta_data['shipping_address_2']) ? $order_meta_data['shipping_address_2'] : '';
	$shipping_city = isset($order_meta_data['shipping_city']) ? $order_meta_data['shipping_city'] : '';
	$shipping_postcode = isset($order_meta_data['shipping_postcode']) ? $order_meta_data['shipping_postcode'] : '';
	$shipping_country = isset($order_meta_data['shipping_country']) ? $order_meta_data['shipping_country'] : '';
	$shipping_phone = isset($order_meta_data['shipping_phone']) ? $order_meta_data['shipping_phone'] : '';
	$shipping_email = isset($order_meta_data['shipping_email']) ? $order_meta_data['shipping_email'] : '';
	$shipping_state = isset($order_meta_data['shipping_state']) ? $order_meta_data['shipping_state'] : '';
	


    // Set billing and shipping address (replace with actual details)
    $billing_address = array(
        'first_name' => $billing_first_name,
        'last_name'  => $billing_last_name,
        'address_1'  => $billing_address_1 ,
		'address_2'  => $billing_address_2,
        'city'       => $billing_city,
        'state'      => $billing_state,
        'postcode'   => $billing_postcode ,
        'country'    => $billing_country,
        'email'      => $billing_email,
        'phone'      => $billing_phone,
		'company' => $billing_company 
    );
	$shipping_address = array(
        'first_name' => $shipping_first_name,
        'last_name'  => $shipping_last_name,
        'address_1'  => $shipping_address_1 ,
		'address_2'  => $shipping_address_2,
        'city'       => $shipping_city,
        'state'      => $shipping_state,
        'postcode'   => $shipping_postcode ,
        'country'    => $shipping_country,
        'email'      => $shipping_email,
        'phone'      => $shipping_phone,
		'company' => $shipping_company 
    );
    $order->set_address($billing_address, 'billing');
    $order->set_address($shipping_address, 'shipping');

    // Set payment method (replace with actual payment method)
    $payment_method = $order_meta_data['payment_method']; // Direct bank transfer
	$order_currency = $order_meta_data['order_currency']; 

    $order->set_payment_method($payment_method);
	$order->set_customer_note($customer_note);
	$order->set_currency( $order_currency);
    // Calculate totals
    $order->calculate_totals();
	$order_id = $order->save();
	// $order = wc_get_order( $order_id );
	// $order->set_status( 'wc-completed' );
	$module =$wpdb->get_var("SELECT post_type FROM {$wpdb->prefix}posts where id=$order_id");
	$order_status =$data_array['order_status'];
	global $wpdb;
	if($module == 'shop_order_placehold'){
		if(!empty($order_status)){
			$wpdb->get_results("Update {$wpdb->prefix}wc_orders set status='$order_status' where id=$order_id");
		}

	}
	else{
		if(!empty($order_status)){
			$wpdb->get_results("Update {$wpdb->prefix}posts set post_status='$order_status' where id=$order_id");
		}
	}
	// $helperss = new \WooCustomerInsightHelper();
	
	// $helperss->WCI_order_status_completed($order_id);
	
	$wpdb->update( $wpdb->prefix . 'posts' , 
	array( 
		'post_excerpt' => $customer_note,
	) , 
	array( 'id' => $order_id ) 
	);
    // Save the order
    

  
$returnArr['ID'] = $order_id;
		$returnArr['MODE'] = $mode_of_affect;
		return $returnArr;
	}
	public function woocommerce_orders_import($data_array , $mode , $check , $unikey , $unikey_name, $line_number) {
		$returnArr = array();	
		global $wpdb;
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;

		$log_table_name = $wpdb->prefix ."import_detail_log";

		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];
		$data_array['post_type'] = 'shop_order';
		$arraykey = array_keys($data_array);
		
		if(!in_array('customer_note',$arraykey)){
			$data_array['post_excerpt'] = '';
		}
		else{
			$data_array['post_excerpt'] = $data_array['customer_note'];
		}
		//$data_array['post_excerpt'] = $data_array['customer_note'];
		if(isset($data_array['order_status'])) {
			$data_array['post_status'] = $data_array['order_status'];}
		/* Assign order date */
		if(!isset( $data_array['order_date'] )) {
			$data_array['post_date'] = current_time('Y-m-d H:i:s');
		} else {
			if(strtotime( $data_array['order_date'] )) {
				$data_array['post_date'] = date( 'Y-m-d H:i:s', strtotime( $data_array['order_date'] ) );
			} else {
				$data_array['post_date'] = current_time('Y-m-d H:i:s');
			}
		}
		if ($mode == 'Insert') {	
			$retID = wp_insert_post( $data_array );
			$mode_of_affect = 'Inserted';
			
			if(is_wp_error($retID) || $retID == '') {
				$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Order. " . $retID->get_error_message();
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode, 'ERROR_MSG' => $retID->get_error_message());
			}
			$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Order ID: ' . $retID;
			$core_instance->detailed_log[$line_number]['id'] = $retID;
			$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
			$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
			$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");

		} else {
			if ($mode == 'Update') {
				if($check == 'ORDERID'){
					if(!empty($data_array['ORDERID'])){
					$orderid = $data_array['ORDERID'];
					$update_query = "select ID from {$wpdb->prefix}posts where ID = '$orderid'";
					$ID_result = $wpdb->get_results($update_query);

					if (is_array($ID_result) && !empty($ID_result)) {
						$retID = $ID_result[0]->ID;
						$data_array['ID'] = $retID;
						wp_update_post($data_array);
						$mode_of_affect = 'Updated';

						$core_instance->detailed_log[$line_number]['Message'] = 'Updated Order ID: ' . $retID;
						$core_instance->detailed_log[$line_number]['id'] = $retID;
						$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
						$core_instance->detailed_log[$line_number]['state'] = 'Updated';
						$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");	
					} else{
						
							$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
							$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
							$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
							return array('MODE' => $mode);
					}
				}
				}else{
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					return array('MODE' => $mode);
					
				}
			}
		}
		$returnArr['ID'] = $retID;
		$returnArr['MODE'] = $mode_of_affect;
		return $returnArr;
	}

	public function woocommerce_coupons_import($data_array , $mode , $check , $unikey , $unikey_name, $line_number) {
		
		global $wpdb; 
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;
		$log_table_name = $wpdb->prefix ."import_detail_log";

		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];

		$returnArr = array();
		
		$data_array['post_type'] = 'shop_coupon';
		$data_array['post_title'] = $data_array['coupon_code'];
		$data_array['post_name'] = $data_array['coupon_code'];
		if(isset($data_array['description'])) {
			$data_array['post_excerpt'] = $data_array['description'];
		}

		/* Post Status Options */
		if ( !empty($data_array['coupon_status']) ) {
			$data_array = $helpers_instance->assign_post_status( $data_array );
		} else {
			$data_array['coupon_status'] = 'publish';
		}

		if ($mode == 'Insert') {
			$retID = wp_insert_post($data_array);
			$mode_of_affect = 'Inserted';
			
			if(is_wp_error($retID) || $retID == '') {
				$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Coupon. " . $retID->get_error_message();
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode, 'ERROR_MSG' => $retID->get_error_message());
			}
			$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Coupon ID: ' . $retID;
			$core_instance->detailed_log[$line_number]['id'] = $retID;
			$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
			$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
			$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");

		} else {
				if($check == 'COUPONID'){
					if(!empty($data_array['COUPONID'])){
					$coupon_id = $data_array['COUPONID'];
					$post_type = $data_array['post_type'];
					$update_query = "select ID from {$wpdb->prefix}posts where ID = '$coupon_id' and post_type = '$post_type' and post_status not in('trash','draft') order by ID DESC";
					$ID_result = $wpdb->get_results($update_query);

					if (is_array($ID_result) && !empty($ID_result)) {
						$retID = $ID_result[0]->ID;
						$data_array['ID'] = $retID;
						wp_update_post($data_array);
						$mode_of_affect = 'Updated';

						$core_instance->detailed_log[$line_number]['Message'] = 'Updated Coupon ID: ' . $retID;
						$core_instance->detailed_log[$line_number]['id'] = $retID;
						$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
						$core_instance->detailed_log[$line_number]['state'] = 'Updated';
						$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");			
					} else{
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
						return array('MODE' => $mode);
					}
				}
				}
				else{
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					return array('MODE' => $mode);
				}
			//} 
		}
		$returnArr['ID'] = $retID;
		$returnArr['MODE'] = $mode_of_affect;
		return $returnArr;
	}

	public function woocommerce_refunds_import($data_array , $mode , $check  ,$unikey , $unikey_name, $line_number) {
		$returnArr = array();
		$mode_of_affect = 'Inserted';
		global $wpdb; 
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;
		$log_table_name = $wpdb->prefix ."import_detail_log";

		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];
		
		$parent_order_id = 0;
		$post_excerpt = '';
		if(isset($data_array['REFUNDID']))
			$order_id = $data_array['REFUNDID'];
		elseif(isset($data_array['post_parent']))
			$parent_order_id = $data_array['post_parent'];
		if(isset($data_array['post_excerpt']))
			$post_excerpt = $data_array['post_excerpt'];
		$get_order_id = $wpdb->get_results($wpdb->prepare("select * from {$wpdb->prefix}posts where ID = %d", $parent_order_id));
		if(!empty($get_order_id)){
			$refund = $get_order_id[0]->ID;
			
			if(isset($refund)){
				$date_format = date('m-j-Y-Hi-a');
				$date_read = date('M j, Y @ H:i a');
				$data_array['post_title'] = 'Refund &ndash;' . $date_read; 
				$data_array['post_type'] = 'shop_order_refund';
				$data_array['post_parent'] = $parent_order_id;
				$data_array['post_status'] = 'wc-completed';
				$data_array['post_name'] = 'refund-'.$date_format;
				$data_array['guid'] = site_url() . '?shop_order_refund=' . 'refund-'.$date_format;
			}
		}
		if ($mode == 'Insert') {
			$retID = wp_insert_post( $data_array );

			update_post_meta($retID , '_refund_reason' , $post_excerpt);
			
			$update_array = array();
			$update_array['ID'] = $parent_order_id;
			$update_array['post_status'] = 'wc-refunded';
			$update_array['post_modified'] = date('Y-m-d H:i:s');
			$update_array['post_modified_gmt'] = date('Y-m-d H:i:s');
			wp_update_post($update_array);

			if(is_wp_error($retID) || $retID == '') {
				$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Refund. " . $retID->get_error_message();
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode, 'ERROR_MSG' => $retID->get_error_message());
			}
			$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Refund ID: ' . $retID;
			$core_instance->detailed_log[$line_number]['id'] = $retID;
			$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
			$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
			$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");

		}
		
		else{
			if($check == 'REFUNDID'){
				if(!empty($data_array['REFUNDID'])){
				$refund_id = $data_array['REFUNDID'];
				$update_query = "select ID from {$wpdb->prefix}posts where ID = '$refund_id' and post_type = 'shop_order_refund' order by ID DESC";
				$ID_result = $wpdb->get_results($update_query);
				if (is_array($ID_result) && !empty($ID_result)) {
					$retID = $ID_result[0]->ID;
					$data_array['ID'] = $retID;
					wp_update_post($data_array);

					update_post_meta($retID , '_refund_reason' , $post_excerpt);
					$mode_of_affect = 'Updated';

					$core_instance->detailed_log[$line_number]['Message'] = 'Updated Refund ID: ' . $retID;
					$core_instance->detailed_log[$line_number]['id'] = $retID;
					$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $retID, true );
					$core_instance->detailed_log[$line_number]['state'] = 'Updated';
					$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");
				}else{
					if($mode == 'Update'){
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
						return array('MODE' => $mode);
					}
					
				}
			}
			}else{
				if($mode == 'Update'){
					$core_instance->detailed_log[$line_number]['Message'] = "Skipped.";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					return array('MODE' => $mode);
				}	
			} 
		} 
		
		$returnArr['ID'] = $retID;
		$returnArr['MODE'] = $mode_of_affect;
		return $returnArr;
	}

	public function woocommerce_attributes_import($data_array , $mode , $check , $unikey , $unikey_name, $line_number) {
		
		global $wpdb;
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;
	
		$returnArr = array();
		$name = $data_array['name'];
		$slug = $data_array['slug'];
		$configure_terms = $data_array['configure_terms'];
		$attr = $data_array['default_sort_order'];
			if($attr == 'Custom ordering'){
				$attr = 'menu_order';
			}
			if($attr == 'Name (numeric)'){
				$attr = 'name_num';
			}
			if($attr == 'Term ID'){
				$attr = 'id';
			}
			if($attr == 'Name'){
				$attr = 'name';
			}
		$attribute=$data_array['enable_archive'];

		$log_table_name = $wpdb->prefix ."import_detail_log";

		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];

		if($check == 'name' && !empty($data_array['name'])) { 
			$result = $wpdb->get_row("select attribute_id from {$wpdb->prefix}woocommerce_attribute_taxonomies where attribute_label='".$name."'");
		}
		if($check == 'slug' && !empty($data_array['slug'])){
			$result = $wpdb->get_row("select attribute_id from {$wpdb->prefix}woocommerce_attribute_taxonomies where attribute_name='".$slug."'");
		}
		if(!empty($data_array['slug'])){
			$duplicate_check = $wpdb->get_row("select attribute_id from {$wpdb->prefix}woocommerce_attribute_taxonomies where attribute_name='".$slug."'");
		}
	
		if($mode == 'Insert') {

			if (!empty($result) || (!empty($duplicate_check))) {
				$core_instance->detailed_log[$line_number]['Message'] = 'Skipped Product attribute';
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				$returnArr['Mode'] = $mode;
				return $returnArr;
			}else{

				$wpdb->query("insert into {$wpdb->prefix}woocommerce_attribute_taxonomies(attribute_label,attribute_name,attribute_type,attribute_orderby,attribute_public) values('".$name."','".$slug."','select','".$attr."','".$attribute."')");
				$id = $wpdb->insert_id;

				$existing_attributes = array();
				$existing_attributes = get_option('_transient_wc_attribute_taxonomies', true);

				$at = array( 
						'attribute_id'=>$id,
						'attribute_name'=>$slug,
						'attribute_label'=>$name,
						'attribute_type'=>'select',
						'attribute_orderby'=>$attr,
						'attribute_public'=>$attribute
					);

				$at=(object)$at;
				array_push($existing_attributes,$at);
				update_option('_transient_wc_attribute_taxonomies',$existing_attributes);
					
				if(isset($configure_terms)){
					$taxo = 'pa_'.$slug;
					register_taxonomy($taxo , 'product');

					$configure_exp = explode(',' , $configure_terms);
					foreach($configure_exp as $config_values){
						$check_term = term_exists($config_values);	
						if(isset($check_term)){
						}else{	
							wp_insert_term($config_values , $taxo);	
						}	
					}
				}

				$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product attribute ID: '.$id;
				$core_instance->detailed_log[$line_number]['id'] = $id;
				$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
			}
			
		}
		
		if($mode == 'Update') {
       
				if(!empty($result)) {
					foreach($result as $res=>$value) {
						$id = $value;
					}

					$wpdb->query("update {$wpdb->prefix}woocommerce_attribute_taxonomies set attribute_label='".$name."',attribute_name='".$slug."',attribute_type='select',attribute_orderby='".$attr."',attribute_public='".$attribute."' where attribute_id='".$id."'");
					$wpdb->query("delete from ".$wpdb->prefix."options where option_name='_transient_wc_attribute_taxonomies'");

					$at = array( 'attribute_id'=>$id,
							'attribute_name'=>$slug,
							'attribute_label'=>$name,
							'attribute_type'=>'select',
							'attribute_orderby'=>$attr,
							'attribute_public'=>$attribute
						);
					$at=(object)$at;
					$a=array($at);
					update_option('_transient_wc_attribute_taxonomies',$a);

					if(isset($configure_terms)){
						$taxo = 'pa_'.$slug;
						$configure_exp = explode(',' , $configure_terms);
						foreach($configure_exp as $config_values){
							$check_term = term_exists($config_values);	
							if(isset($check_term)){
							}else{	
								if($mode == 'Import-Update'){
									wp_insert_term($config_values , $taxo);	
								}	
							}	
						}
					}

					$core_instance->detailed_log[$line_number]['Message'] = 'Updated Product attribute ID: '.$id;
					$core_instance->detailed_log[$line_number]['id'] = $id;
					$core_instance->detailed_log[$line_number]['state'] = 'Updated';
					$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");
					
				} else{
					if($mode == 'Update'){
						$core_instance->detailed_log[$line_number]['Message'] = 'Skipped';
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
						return array('MODE' => $mode);
					}
				}                                                             
		}

		$returnArr['ID'] = $id;
		return $returnArr;
	}

	public function woocommerce_tags_import($data_array , $mode , $check , $unikey , $unikey_name, $line_number) {

		global $wpdb;
		$helpers_instance = ImportHelpers::getInstance();
		$core_instance = CoreFieldsImport::getInstance();
		global $core_instance;

		$returnArr = array();
		$name = $data_array['name']; 
		$description = $data_array['description'];
		$slug = $data_array['slug'];
		$log_table_name = $wpdb->prefix ."import_detail_log";
		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];

		if ($check == 'TERMID' && !empty($data_array['TERMID'])) {
			$term_id = $data_array['TERMID'];
			$termid =$wpdb->get_row("select term_id from {$wpdb->prefix}terms where term_id = '$term_id' ");
		}
		if($check == 'slug' && !empty($data_array['slug'])) {
			$termid =$wpdb->get_row("select term_id from {$wpdb->prefix}terms where slug='".$slug."'");
		}

		if($mode == 'Insert') {
			if (!empty($termid)) {

				$core_instance->detailed_log[$line_number]['Message'] = 'Skipped Product tag';
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				$returnArr['Mode'] = $mode;
				return $returnArr;
				#skipped
			}else{
				$wpdb->query("insert into {$wpdb->prefix}terms(name,slug) values ('".$name."','".$slug."')");
				$id = $wpdb->insert_id;
				$wpdb->query("insert into {$wpdb->prefix}term_taxonomy(term_taxonomy_id,term_id,taxonomy,description) values('".$id."','".$id."','product_tag','".$description."')");
				
				$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product tag ID: '.$id;
				$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
				$core_instance->detailed_log[$line_number]['id'] = $id;
				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
			}
		}
		
		if($mode == 'Update'){
			if (!empty($termid)) {
				foreach($termid as $term =>$value) {
					$id = $value;
				}
				$wpdb->query("update {$wpdb->prefix}terms set name='".$name."',slug='".$slug."' where term_id='".$id."'");
				$wpdb->query("update {$wpdb->prefix}term_taxonomy set term_taxonomy_id='".$id."',term_id='".$id."',taxonomy='product_tag',description='".$description."' where term_id='".$id."'"); 
				
				$core_instance->detailed_log[$line_number]['Message'] = 'Updated Product tag ID: '.$id;
				$core_instance->detailed_log[$line_number]['id'] = $id;
				$core_instance->detailed_log[$line_number]['state'] = 'Updated';
				$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");
			}else{
				$core_instance->detailed_log[$line_number]['Message'] = 'Skipped.';
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
				$returnArr['Mode'] = $mode;
				return $returnArr;
				//return array('MODE' => $mode);
			}
		}
		$returnArr['ID'] = $id;
		return $returnArr;
	}
	public function woocommerce_product_import($data_array, $mode, $type, $unmatched_row , $check , $unikey , $unikey_name, $line_number  , $acf,$pods, $toolset, $header_array ,$value_array, $wpml_values,$poly_values,$update_based_on) {

		global $wpdb,$core_instance,$sitepress; 
		$wpml_values = null;
		$core_instance = CoreFieldsImport::getInstance();
		$helpers_instance = ImportHelpers::getInstance();
		$log_table_name = $wpdb->prefix ."import_detail_log";
		$data_array['PRODUCTSKU']=isset($data_array['PRODUCTSKU'])?$data_array['PRODUCTSKU']:'';
		$data_array['PRODUCTSKU'] = trim($data_array['PRODUCTSKU']);
		$returnArr = array();
		$assigned_author = '';
		$mode_of_affect = 'Inserted';
		$data_array['post_type'] = 'product';
		$data_array = $core_instance->import_core_fields($data_array , $mode ,$line_number);
		$post_type = $data_array['post_type'];
		if($check == 'ID'){
			if(!empty($data_array['ID'])){
			$ID = $data_array['ID'];	
			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
				$language_code = $wpml_values['language_code'];
				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}icl_translations pm ON p.ID = pm.element_id WHERE p.ID = $title AND p.post_type = '$post_type' AND p.post_status != 'trash' AND pm.language_code = '{$language_code}'");
			}
			elseif(isset($poly_values) && !empty($poly_values)){
				$language_code = $poly_values['language_code'];
				if(!empty($ID)){
					$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.ID=$ID AND p.post_status != 'trash'");
				}
			}
			else{
				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE ID = '$ID' AND post_type = '$post_type' AND post_status != 'trash' order by ID DESC ");			
			}
		}
		}
		if($check == 'post_title'){
			if(!empty($data_array['post_title'])){
			$title = $data_array['post_title'];
			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
				$language_code = $wpml_values['language_code'];
				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}icl_translations pm ON p.ID = pm.element_id WHERE p.post_title = '$title' AND p.post_type = '$post_type' AND p.post_status != 'trash' AND pm.language_code = '{$language_code}'");
			}
			elseif(isset($poly_values) && !empty($poly_values)){
				$language_code = $poly_values['language_code'];
				$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.post_title='$title' AND p.post_status != 'trash'");
			}
			else{
				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title = \"$title\" AND post_type = \"$post_type\" AND post_status != \"trash\" order by ID DESC ");		
			}
		}
		}
		if($check == 'post_name'){
			$name = $data_array['post_name'];
			if(!empty($data_array['post_name'])){
			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
				$language_code = $wpml_values['language_code'];
				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}icl_translations pm ON p.ID = pm.element_id WHERE p.post_name = '$name' AND p.post_type = '$post_type' AND p.post_status != 'trash' AND pm.language_code = '{$language_code}'");
			}
			elseif(isset($poly_values) && !empty($poly_values)){
				$language_code = $poly_values['language_code'];
				$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.post_name='$name'");
			}
			else{
			$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_name = '$name' AND post_type = '$post_type' AND post_status != 'trash' order by ID DESC ");	
			}
			}
		}
		if($check == 'PRODUCTSKU'){
			if(!empty($data_array['PRODUCTSKU'])){
			$sku = $data_array['PRODUCTSKU'];
			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
				$language_code = $wpml_values['language_code'];
				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id inner join {$wpdb->prefix}icl_translations icl ON pm.post_id = icl.element_id WHERE p.post_type = 'product' AND p.post_status != 'trash' and pm.meta_value = '$sku' and icl.language_code = '{$language_code}'");               
			}
			elseif(isset($poly_values) && !empty($poly_values)){
				$language_code = $poly_values['language_code'];
				$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}postmeta pm ON p.ID=pm.post_id inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.post_name='$name' and pm.meta_value = '$sku'");
			}
			else{
				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id WHERE p.post_type = 'product' AND p.post_status != 'trash' and pm.meta_value = '$sku' ");
			}
		}
		}

		$update = array('ID','post_title','post_name','PRODUCTSKU');
		if($update_based_on == 'skip' && in_array($check, $update)){
			if(empty($get_result)) {
				$core_instance->detailed_log[$line_number]['Message'] = "Skipped,Due to existing ".$check." is not presents.";
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
			}	
		}
			if(!in_array($check, $update)){
				if(is_plugin_active('advanced-custom-fields-pro/acf.php')||is_plugin_active('advanced-custom-fields/acf.php')){
					if(is_array($acf)){
						$get_key = "";
						foreach($acf as $acf_key => $acf_value){
							if($acf_key == $check){
								$get_key= array_search($acf_value , $header_array);
							}
							if($get_key && isset($value_array[$get_key])){
								$csv_element = $value_array[$get_key];								
								$get_result = $wpdb->get_results("SELECT post_id FROM {$wpdb->prefix}postmeta as a join {$wpdb->prefix}posts as b on a.post_id = b.ID WHERE a.meta_key = '$check' AND a.meta_value = '$csv_element' AND b.post_status != 'trash' order by a.post_id DESC ");
							}
						}	
					}		
					if(empty($get_result)) {
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to existing field value is not presents.";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					}
				}
			}
			if(!in_array($check, $update)){
				if(is_plugin_active('pods/init.php')){
					if(is_array($pods)){
						
						foreach($pods as $pods_key => $pods_value){
							if($pods_key == $check){
								$get_key= array_search($pods_value , $header_array);
							}
							if(isset($value_array[$get_key])){
								$csv_element = $value_array[$get_key];	
							}
							
							$get_result = $wpdb->get_results("SELECT post_id FROM {$wpdb->prefix}postmeta as a join {$wpdb->prefix}posts as b on a.post_id = b.ID WHERE a.meta_key = '$check' AND a.meta_value = '$csv_element' AND b.post_status != 'trash' order by a.post_id DESC ");
						}	
					}	
					if(empty($get_result)) {
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to existing field value is not presents.";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					}	
				}
			}
			if(!in_array($check, $update)){
				if(is_plugin_active('types/wpcf.php')){
					if(is_array($toolset)){
						foreach($toolset as $tool_key => $tool_value){
							if($tool_key == $check){
								$get_key= array_search($tool_value , $header_array);
							}
							if(isset($value_array[$get_key]) && isset($get_key)){
								$csv_element = $value_array[$get_key];
								$key='wpcf-'.$check;
								$get_result = $wpdb->get_results("SELECT post_id FROM {$wpdb->prefix}postmeta as a join {$wpdb->prefix}posts as b on a.post_id = b.ID WHERE a.meta_key = '$key' AND a.meta_value = '$csv_element' AND b.post_status != 'trash' order by a.post_id DESC ");	
							}
							
						}	
					}	
					if(empty($get_result)) {
						$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to existing field value is not presents.";
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					}	
				}
			}
	
		$updated_row_counts = $helpers_instance->update_count($unikey,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];

		if ($mode == 'Insert') {
			if(!isset( $data_array['post_date'] )) {
				$data_array['post_date'] = current_time('Y-m-d H:i:s');
			} else {	
				if(strtotime( $data_array['post_date'] )) {
					$data_array['post_date'] = date( 'Y-m-d H:i:s', strtotime( $data_array['post_date'] ) );
				} else {
					$data_array['post_date'] = current_time('Y-m-d H:i:s');
				}
			}
			if (isset($get_result) && is_array($get_result) && !empty($get_result)) {
				#skipped
				$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to duplicate Product found!.";
				$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				return array('MODE' => $mode);
			}else{
				
				$post_id = wp_insert_post($data_array); 
				$data_array['post_format']=isset($data_array['post_format'])?$data_array['post_format']:'';
				set_post_format($post_id , $data_array['post_format']);	
				if(!empty($data_array['PRODUCTSKU'])){
					update_post_meta($post_id , '_sku' , $data_array['PRODUCTSKU']);
				}
				if(is_wp_error($post_id) || $post_id == '') {
					# skipped
					// $core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Product. " .$post_id->get_error_message();
					
					if(is_wp_error($post_id)){
						$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Product. " .$post_id->get_error_message();
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					}
					else{
						$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Product. " ;
						$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					}
					
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					return array('MODE' => $mode);
				}

				if($unmatched_row == 'true'){
					global $wpdb;
					$post_entries_table = $wpdb->prefix ."post_entries_table";
					$file_table_name = $wpdb->prefix."smackcsv_file_events";
					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey'");	
					$file_name = $get_id[0]->file_name;
					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Inserted')");
				}

				$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product ID: ' . $post_id . ', ' . $assigned_author;
				$core_instance->detailed_log[$line_number]['webLink'] = get_permalink( $post_id );
				$core_instance->detailed_log[$line_number]['id'] = $post_id;
				$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $post_id, true );
				$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
			}	
		}	
		if($mode == 'Update'){			
			if(isset($core_instance->detailed_log[$line_number]['Message']) && preg_match("(Skipped)", $core_instance->detailed_log[$line_number]['Message']) !== 0) {					
				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
				$returnArr['MODE'] = $mode_of_affect;
			}	
			else {						
			if (is_array($get_result) && !empty($get_result)) {
				if(!in_array($check, $update)){
					$post_id = $get_result[0]->post_id;		
					$data_array['ID'] = $post_id;
				}else{
					$post_id = $get_result[0]->ID;	
					$data_array['ID'] = $post_id;
				}
				wp_update_post($data_array);
				$data_array['post_format']=isset($data_array['post_format'])?$data_array['post_format']:'';
				set_post_format($post_id , $data_array['post_format']);		
				if(!empty($data_array['PRODUCTSKU'])){
					update_post_meta($post_id , '_sku' , $data_array['PRODUCTSKU']);
				}

				if($unmatched_row == 'true'){
					global $wpdb;
					$post_entries_table = $wpdb->prefix ."post_entries_table";
					$file_table_name = $wpdb->prefix."smackcsv_file_events";
					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey'");	
					$file_name = $get_id[0]->file_name;
					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Updated')");
				}

				$core_instance->detailed_log[$line_number]['Message'] = 'Updated Product ID: ' . $post_id . ', ' . $assigned_author;
				$core_instance->detailed_log[$line_number]['id'] = $post_id;
				$core_instance->detailed_log[$line_number]['webLink'] = get_permalink( $post_id );
				$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $post_id, true );
				$core_instance->detailed_log[$line_number]['state'] = 'Updated';
				$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");

			}else{
				$posttitle = $data_array['post_title'];
				$productsku = $data_array['PRODUCTSKU'];
				if(!empty($posttitle)){
					$post_id = wp_insert_post($data_array); 
					$data_array['post_format'] = isset($data_array['post_format'])?$data_array['post_format']:'';
					set_post_format($post_id , $data_array['post_format']);
					if(is_wp_error($post_id) || $post_id == '') {
						# skipped
						if(is_wp_error($post_id)){
							$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Product. " .$post_id->get_error_message();
							$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						}
						else{
							$core_instance->detailed_log[$line_number]['Message'] = "Can't insert this Product. " ;
							$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
						}						
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
						return array('MODE' => $mode);
					}
					if($unmatched_row == 'true'){
						global $wpdb;
						$post_entries_table = $wpdb->prefix ."post_entries_table";
						$file_table_name = $wpdb->prefix."smackcsv_file_events";
						$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey'");	
						$file_name = $get_id[0]->file_name;
						$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Inserted')");
					}
					$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product ID: ' . $post_id . ', ' . $assigned_author;
					$core_instance->detailed_log[$line_number]['id'] = $post_id;
					$core_instance->detailed_log[$line_number]['Sku'] = $data_array['PRODUCTSKU'];
					$core_instance->detailed_log[$line_number]['webLink'] = get_permalink( $post_id );
					$core_instance->detailed_log[$line_number]['adminLink'] = get_edit_post_link( $post_id, true );
					$core_instance->detailed_log[$line_number]['state'] = 'Inserted';
					$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");	
				}
				else{
					$core_instance->detailed_log[$line_number]["Message"] = "Skipped. SKU: ".$productsku."<br>";
					$core_instance->detailed_log[$line_number]['state'] = 'Skipped';
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
					// return array('MODE' => $mode);
				}
				
			
			}
		}

		}

		$returnArr['ID'] = $post_id;
		$returnArr['MODE'] = $mode_of_affect;
		if (!empty($data_array['post_author'])) {
			$returnArr['AUTHOR'] = isset($assigned_author) ? $assigned_author : '';
		}
		return $returnArr;
	}
	// public function woocommerce_product_import_new($post_values , $mode , $type, $unmatched_row, $check , $unikey_value , $unikey_name, $line_number, $acf ,$pods, $toolset,$header_array, $value_array,  $wpml_values,$poly_values,$product_meta_data,$attr_meta_data){
		
	// 	$post_values = array_merge($post_values,$product_meta_data);
	// 	global $wpdb;
	// 	global $wpdb,$core_instance,$sitepress; 
	// 	$wpml_values = null;
	// 	$core_instance = CoreFieldsImport::getInstance();
	// 	$helpers_instance = ImportHelpers::getInstance();
	// 	$media_instance = MediaHandling::getInstance();

	// 	$log_table_name = $wpdb->prefix ."import_detail_log";
	// 	$returnArr = array();
	// 	$assigned_author = '';
	// 	$mode_of_affect = 'Inserted';
	// 	if (class_exists('WC_Product')) {
	// 		$product_type = $post_values['product_type'];
	// 		if($product_type == 'variation' || $product_type== 8){
	// 			$post_type = 'product_variation';
	// 		}
	// 		else{
	// 			$post_type = 'product';
	// 		}
	// 		$sku = $post_values['PRODUCTSKU'];
	// 		if($check == 'ID'){	
	// 			$ID = $data_array['ID'];	
	// 			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
	// 				$language_code = $wpml_values['language_code'];
	// 				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}icl_translations pm ON p.ID = pm.element_id WHERE p.ID = $title AND p.post_type = '$post_type' AND p.post_status != 'trash' AND pm.language_code = '{$language_code}'");
	// 			}
	// 			elseif(isset($poly_values) && !empty($poly_values)){
	// 				$language_code = $poly_values['language_code'];
	// 				if(!empty($ID)){
	// 					$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.ID=$ID AND p.post_status != 'trash'");
	// 				}
	// 			}
	// 			else{
	// 				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE ID = '$ID' AND post_type = '$post_type' AND post_status != 'trash' order by ID DESC ");			
	// 			}
	// 		}
	// 		if($check == 'post_title'){
	// 			$title = $post_values['post_title'];
	// 			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
	// 				$language_code = $wpml_values['language_code'];
	// 				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}icl_translations pm ON p.ID = pm.element_id WHERE p.post_title = '$title' AND p.post_type = '$post_type' AND p.post_status != 'trash' AND pm.language_code = '{$language_code}'");
	// 			}
	// 			elseif(isset($poly_values) && !empty($poly_values)){
	// 				$language_code = $poly_values['language_code'];
	// 				$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.post_title='$title' AND p.post_status != 'trash'");
	// 			}
	// 			else{
	// 				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title = \"$title\" AND post_type = \"$post_type\" AND post_status != \"trash\" order by ID DESC ");		
	// 			}
				
	// 		}
	// 		if($check == 'post_name'){
	// 			$name = $post_values['post_name'];
	// 			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
	// 				$language_code = $wpml_values['language_code'];
	// 				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}icl_translations pm ON p.ID = pm.element_id WHERE p.post_name = '$name' AND p.post_type = '$post_type' AND p.post_status != 'trash' AND pm.language_code = '{$language_code}'");
	// 			}
	// 			elseif(isset($poly_values) && !empty($poly_values)){
	// 				$language_code = $poly_values['language_code'];
	// 				$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.post_name='$name'");
	// 			}
	// 			else{
	// 			$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_name = '$name' AND post_type = '$post_type' AND post_status != 'trash' order by ID DESC ");	
	// 			}
	// 			}
	// 		if($check == 'PRODUCTSKU'){
	// 			$sku = $post_values['PRODUCTSKU'];
	// 			if($sitepress != null && isset($wpml_values['language_code']) && !empty($wpml_values['language_code'])) {
	// 				$language_code = $wpml_values['language_code'];
	// 				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id inner join {$wpdb->prefix}icl_translations icl ON pm.post_id = icl.element_id WHERE p.post_type = 'product' AND p.post_status != 'trash' and pm.meta_value = '$sku' and icl.language_code = '{$language_code}'");               
	// 			}
	// 			elseif(isset($poly_values) && !empty($poly_values)){
	// 				$language_code = $poly_values['language_code'];
	// 				$get_result=$wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts as p inner join {$wpdb->prefix}postmeta pm ON p.ID=pm.post_id inner join {$wpdb->prefix}term_relationships as tr ON tr.object_id=p.ID inner join {$wpdb->prefix}term_taxonomy as tax on tax.term_taxonomy_id=tr.term_taxonomy_id inner join {$wpdb->prefix}terms as t on t.term_id=tax.term_id  where tax.taxonomy ='language'  and t.slug='$language_code' and p.post_name='$name' and pm.meta_value = '$sku'");
	// 			}
	// 			else{
	// 				$get_result =  $wpdb->get_results("SELECT DISTINCT p.ID FROM {$wpdb->prefix}posts p join {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id WHERE p.post_type = 'product' AND p.post_status != 'trash' and pm.meta_value = '$sku' ");
	// 			}
	// 		}
	// 		$update = array('ID','post_title','post_name','PRODUCTSKU');
	// 		if($mode == 'Insert'){
	// 			if (isset($get_result) && is_array($get_result) && !empty($get_result)) {
	// 				#skipped
	// 				$core_instance->detailed_log[$line_number]['Message'] = "Skipped, Due to duplicate Product found!.";
	// 				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
	// 				return array('MODE' => $mode);
	// 			}else{
					
	// 				if($post_values['product_type']){
	// 					$product_type =$post_values['product_type'];
	// 					if ($post_values['product_type'] == 1) {
	// 						$product_type = 'simple';
	// 					}
	// 					if ($post_values['product_type'] == 2) {
	// 						$product_type = 'grouped';
	// 					}
	// 					if ($post_values['product_type'] == 3) {
	// 						$product_type = 'external';
	// 					}
	// 					if ($post_values['product_type'] == 4) {
	// 						$product_type = 'variable';
	// 					}
	// 					if ($post_values['product_type'] == 5) {
	// 						$product_type = 'subscription';
	// 					}
	// 					if ($post_values['product_type'] == 6) {
	// 						$product_type = 'variable-subscription';
	// 					}
	// 					if ($post_values['product_type'] == 7) {
	// 						$product_type = 'bundle';
	// 					}	
	// 					if($post_values['product_type'] == 8){
	// 						$product_type = 'variation';
	// 					}
	// 					if($product_type == 'external'){
	// 						$product = new \WC_Product_External();
	// 					}
	// 					elseif($product_type == 'variable'){
	// 						$product = new \WC_Product_Variable();
	// 					}
	// 					elseif($product_type == 'grouped'){
	// 						$product = new	\WC_Product_Grouped();
	// 					}
	// 					elseif($product_type == 'variation'){
	// 						$product = new \WC_Product_Variation();							
	// 					}
	// 					else{
	// 						$product = new  \WC_Product_Simple();
	// 					}
						
	// 					$title = $post_values['post_title'];
	// 					$post_status = $post_values['post_status'];
	
	// 					$product->set_name($title); 
						
	// 					// $product->set_sku($post_values['PRODUCTSKU']);
	// 					$product_sku = array();

	// 					$args = array('status'   => 'publish','return'   => 'ids','limit'    => -1);
	// 					$products = wc_get_products( $args );
	// 					foreach($products as $id){
	// 						$product_old = wc_get_product($id);
	// 						$product_sku []= $product_old->get_sku();
	// 					}
						
	// 					$prod_sku=$post_values['PRODUCTSKU'];
	// 					if(!in_array($prod_sku,$product_sku)){
	// 						$product->set_sku($prod_sku);
	// 					}
	// 					else{
	// 						$core_instance->detailed_log[$line_number]["Message"] = "Skipped. SKU: ".$post_values['PRODUCTSKU']."<br>";
	// 						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
	// 						return array('MODE' => $mode); 
	// 					}
	// 					$product_id = $product->save();
	// 				}
	// 				if($unmatched_row == 'true'){
	// 					global $wpdb;
	// 					$post_entries_table = $wpdb->prefix ."post_entries_table";
	// 					$file_table_name = $wpdb->prefix."smackcsv_file_events";
	// 					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey'");	
	// 					$file_name = $get_id[0]->file_name;
	// 					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$product_id}','{$type}', '{$file_name}','Inserted')");
	// 				}
	
	// 				$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product ID: ' . $product_id . ', ' . $assigned_author;
	// 				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
	// 			}
				
	// 		}
	// 		elseif($mode == 'Update'){
	// 			if(isset($core_instance->detailed_log[$line_number]['Message']) && preg_match("(Skipped)", $core_instance->detailed_log[$line_number]['Message']) !== 0) {					
	// 				$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
	// 				$returnArr['MODE'] = $mode_of_affect;
	// 			}	
	// 			else {						
	// 			if (is_array($get_result) && !empty($get_result)) {
	// 				if(!in_array($check, $update)){
	// 					$post_id = $get_result[0]->post_id;		
	// 					$data_array['ID'] = $post_id;
	// 				}else{
	// 					$post_id = $get_result[0]->ID;	
	// 					$data_array['ID'] = $post_id;
	// 				}
	// 				// if($post_type == 'variation'){
	// 				// 	wc_get_product($id)
	// 				// }
	// 				// else{
	// 					$product = wc_get_product($post_id);
	// 				// }
	// 				$product_id = $product->save();
	// 				if($unmatched_row == 'true'){
	// 					global $wpdb;
	// 					$post_entries_table = $wpdb->prefix ."post_entries_table";
	// 					$file_table_name = $wpdb->prefix."smackcsv_file_events";
	// 					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey'");	
	// 					$file_name = $get_id[0]->file_name;
	// 					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Updated')");
	// 				}
	
	// 				$core_instance->detailed_log[$line_number]['Message'] = 'Updated Product ID: ' . $product_id . ', ' . $assigned_author;
	// 				$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey'");
	
	// 			}
	// 			else{
	// 				$post_title = $post_values['post_title'];
	// 				$product_type = $post_values['product_type'];
	// 				if(!empty($post_title)){
	// 					if ($post_values['product_type'] == 1) {
	// 						$product_type = 'simple';
	// 					}
	// 					if ($post_values['product_type'] == 2) {
	// 						$product_type = 'grouped';
	// 					}
	// 					if ($post_values['product_type'] == 3) {
	// 						$product_type = 'external';
	// 					}
	// 					if ($post_values['product_type'] == 4) {
	// 						$product_type = 'variable';
	// 					}
	// 					if ($post_values['product_type'] == 5) {
	// 						$product_type = 'subscription';
	// 					}
	// 					if ($post_values['product_type'] == 6) {
	// 						$product_type = 'variable-subscription';
	// 					}
	// 					if ($post_values['product_type'] == 7) {
	// 						$product_type = 'bundle';
	// 					}	
	// 					if($post_values['product_type'] == 8){
	// 						$product_type = 'variation';
	// 					}
	// 					if($product_type == 'external'){
	// 						$product = new \WC_Product_External();
	// 					}
	// 					elseif($product_type == 'variable'){
	// 						$product = new \WC_Product_Variable();
	// 					}
	// 					elseif($product_type == 'grouped'){
	// 						$product = new	\WC_Product_Grouped();
	// 					}
	// 					elseif($product_type == 'variation'){
	// 						$product = new \WC_Product_Variation();							
	// 					}
	// 					else{
	// 						$product = new  \WC_Product_Simple();
	// 					}
						
	// 					$title = $post_values['post_title'];
	// 					$post_status = $post_values['post_status'];
	
	// 					$product->set_name($title); 
						
	// 					// $product->set_sku($post_values['PRODUCTSKU']);
	// 					$product_sku = array();
	// 					$args = array('status'   => 'publish','return'   => 'ids','limit'    => -1);
	// 					$products = wc_get_products( $args );
	// 					$product_statuses = array('publish', 'draft', 'future', 'private', 'pending','trash');
	// 					$products_var = wc_get_products(array('status' => $product_statuses , 'limit' => -1));
	// 					$variable_product_ids = [];
	// 					foreach($products_var as $product){
	// 						if ($product->is_type('variable')) {
	// 							$variable_product_ids[] = $product->get_id();
	// 						}
	// 					}	
	// 					$variation_count = 0;
	// 					$variation_ids = array();
	// 					foreach($variable_product_ids as $variable_product_id){
	// 						$variable_product = wc_get_product($variable_product_id);
	// 						$variation_ids[]  = $variable_product->get_children();
	// 					}
	// 					$extracted_ids = [];
	// 					foreach ($variation_ids as $v_ids) {
	// 						foreach ($v_ids as $v_id) {
	// 							$extracted_ids[] = $v_id;
	// 						}
	// 					}
	// 					$products =array_merge($products,$extracted_ids);
	// 					foreach($products as $id){
	// 						$product_old = wc_get_product($id);
	// 						if(!empty($product_old->get_sku())){
	// 							$product_sku []= $product_old->get_sku();	
	// 						}
	// 						// $product_sku []= $product_old->get_sku();
	// 					}
						
	// 					$prod_sku=$post_values['PRODUCTSKU'];
	// 					if(!in_array($prod_sku,$product_sku)){

	// 						$product->set_sku($prod_sku);
	// 					}
	// 					else{
	// 						$core_instance->detailed_log[$line_number]["Message"] = "Skipped. SKU: ".$post_values['PRODUCTSKU']."<br>";
	// 						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey'");
	// 						return array('MODE' => $mode); 
	// 					}
	// 					$product_id = $product->save();
	// 					if($unmatched_row == 'true'){
	// 						global $wpdb;
	// 						$post_entries_table = $wpdb->prefix ."post_entries_table";
	// 						$file_table_name = $wpdb->prefix."smackcsv_file_events";
	// 						$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey'");	
	// 						$file_name = $get_id[0]->file_name;
	// 						$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$product_id}','{$type}', '{$file_name}','Inserted')");
	// 					}
		
	// 					$core_instance->detailed_log[$line_number]['Message'] = 'Inserted Product ID: ' . $product_id . ', ' . $assigned_author;
	// 					$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey'");
	// 				}

	// 			}

	// 		}
	// 	}

	// 		foreach($post_values as $post_key => $post_val){
	// 			switch($post_key){
	// 				case 'stock_qty':
	// 					$product->set_stock_quantity($post_values[$post_key]);
	// 					break;
	// 				case 'stock_status':
	// 					$product->set_stock_status($post_values[$post_key]);
	// 					break;
	// 				case 'price':
	// 					$product->set_price($post_values[$post_key]); 
	// 					break;
	// 				case 'regular_price': 
	// 					$product->set_regular_price( 19.99 );
	// 					break;
	// 				case 'manage_stock':
	// 					if($post_values[$post_key] == 'yes'){
	// 						$product->set_manage_stock( true ); 
	// 					}
	// 					elseif($post_values[$post_key] == 'no'){
	// 						$product->set_manage_stock(false); 
	// 					}
	// 					break;
	// 				// case 'PRODUCTSKU':
	// 				// 	$product->set_sku($post_values[$post_key]);
	// 				// 	break;
	// 				case 'weight':
	// 					$product->set_weight($post_values[$post_key]);
	// 					break;
	// 				case 'length':
	// 					$product->set_length($post_values[$post_key]); 
	// 					break;
	// 				case 'height':
	// 					$product->set_height($post_values[$post_key]);
	// 					break;
	// 				case 'width':
	// 					$product->set_width($post_values[$post_key]);
	// 					break;
	// 				case 'tax_status':
	// 					if ($post_values[$post_key] == 1) {
	// 						$tax_status = 'taxable';
	// 					}
	// 					if ($post_values[$post_key] == 2) {
	// 						$tax_status = 'shipping';
	// 					}
	// 					if ($post_values[$post_key] == 3) {
	// 						$tax_status = 'none';
	// 					}
	// 					$product->set_tax_status($tax_status);
	// 					break;
	// 				case 'post_content':
	// 					if(!empty($post_values)){
	// 						$product->set_description($post_values[$post_key]); 
	// 					}
						
	// 					break;				
	// 				case 'visibility':
	// 					$visibility_mapping = array( '1'=>'visible','2'=>'catalog','3' => 'search','4' => 'hidden');
	// 					if(is_numeric($post_values[$post_key])){
	// 						$visibility=array_key_exists($post_values[$post_key],$visibility_mapping)?$visibility_mapping[$post_values[$post_key]]:'';
	// 						if(!empty($visibility)){
	// 							$product->set_catalog_visibility($visibility);
	// 						}
							
	// 					}
	// 					else{
	// 						$product->set_catalog_visibility($post_values[$post_key]);
	// 					}
						
	// 					break;
	// 				case 'post_excerpt':
	// 					$product->set_short_description($post_values[$post_key]);
	// 					break;
	// 				case 'downloadable' :
	// 					if($post_values[$post_key] == 'yes'){
	// 						$product->set_downloadable( true );
	// 					}
	// 					else{
	// 						$product->set_downloadable(false);
	// 					}
	// 					// $metaData['_downloadable'] = $data_array[$ekey];
	// 					break;
	// 				case 'virtual':
	// 					if($post_values[$post_key] == 'yes'){
	// 						$product->set_virtual(true);
	// 					}
	// 					else{
	// 						$product->set_virtual(false);
	// 					}
	// 					break;
	// 				case 'manage_stock':
	// 					if($post_values[$post_key] == 'yes'){
	// 						$product->set_manage_stock(true); 
	// 					}
	// 					elseif($post_values[$post_key] == 'no'){
	// 						$product->set_manage_stock(false); 
	// 					}
	// 					break;
	// 				case 'set_date_on_sale_from':
	// 					$product->set_date_on_sale_from($post_values[$post_key]);
	// 					break;
	// 				case 'set_date_on_sale_to':
	// 					$product->set_date_on_sale_to($post_values[$post_key]); 
	// 					break;
	// 				case 'product_shipping_class' :
	// 				case 'variation_shipping_class' :
				
	// 					$class_name = $post_values[$post_key];
	// 					$class = $wpdb->get_results("SELECT term_id FROM {$wpdb->prefix}terms where name = '{$class_name}' ");
	// 					if(!empty($class)) {
	// 						$class_id = $class[0]->term_id;
	// 						if ($product = wc_get_product($pID)) {
	// 							$product->set_shipping_class_id($class_id);
	// 							$product->save();
	// 						}
	// 					}
	// 					break;
	// 				case 'product_image_gallery' :

	// 					$plugin = 'product';
						
	// 					if(!empty($post_values[$post_key])){
	// 						//$get_all_gallery_images = explode('|', $data_array[$ekey]);
	// 						if (strpos($data_array[$ekey], ',') !== false) {
	// 							$get_all_gallery_images = explode(',', $post_values[$post_key]);
	// 						} elseif (strpos($data_array[$ekey], '|') !== false) {
	// 							$get_all_gallery_images = explode('|', $post_values[$post_key]);
	// 						}
	// 						else{
	// 							$get_all_gallery_images[] = $post_values[$post_key];
	// 						}
				
	// 						$gallery_image_ids = '';
	// 						foreach($get_all_gallery_images as $gallery_image) {
	// 							if(is_numeric($gallery_image)) {
	// 								$attachids[]=$gallery_image;
	// 							//WooCommerceMetaImport::$media_instance->productimageMetaImports($gallery_image,$image_meta);
	// 							//WooCommerceMetaImport::$media_instance->image_import($data_arrays);
	// 								$gallery_image_ids .= $gallery_image . ',';
	// 							} else {
	// 								$attachmentId = WooCommerceCoreImport::$media_instance->image_meta_table_entry($image_meta, $pID, 'product_image_gallery', $gallery_image, $hash_key, 'product', 'post',$templatekey,$gmode);	
	// 								$atachids[]=$attachmentId;
	// 								$gallery_image_ids .= $attachmentId . ',';
	// 							}
	// 						}
		
	// 						//update_image_meta
	// 						$get_existing_image_option = get_option('smack_schedule_image_exists_product_'.$product_id);
	// 						if($get_existing_image_option){
	// 							WooCommerceCoreImport::$media_instance->acfimageMetaImports($atachids, $image_meta, $plugin);
	// 							delete_option('smack_schedule_image_exists_product_'.$product_id);
	// 						}
		
	// 						//WooCommerceMetaImport::$media_instance->acfimageMetaImports($attachids,$image_meta,$plugin);
	// 						// $product_image_gallery[$ekey] = $gallery_image_ids;
	// 						$product->set_gallery_image_ids($gallery_image_ids);
	// 					}
	// 					break;
	// 				case 'downloadable':
	// 					if($post_values[$post_key]){
	// 						$product->set_downloads( $downloads );
	// 					}
	// 					break;
	// 				case 'downloadable_files' :
	// 					$downloadable_files = '';
	// 					if ($post_values[$post_key]) {
	// 						$exp_key = array();
	// 						$downloads = array();
	// 						$exploded_file_data = explode('|', $post_values[$post_key]);
	// 						foreach($exploded_file_data as $file_datas){
	// 							$exploded_separate = explode(',', $file_datas);
								
    
	// 							$download = new \WC_Product_Download();
	// 							$attachment_id= $media_instance->media_handling($exploded_separate[1], $product_id,$post_values,'','','',$header_array,$value_array);
	// 							$file_url = wp_get_attachment_url( $attachment_id ); 
	// 							$download->set_name( $exploded_separate[0]);
	// 							$download->set_id( md5( $file_url ) );
	// 							$download->set_file( $file_url );
								
	// 							$downloads[] = $download;
								
								
	// 							// $convert_value = $exploded_separate[1];
	// 							// $file_name = hash_hmac('md5', "$convert_value" , 'secret');
		
	// 							// $exp_key[$file_name]['id'] = $file_name;
	// 							// $exp_key[$file_name]['name'] = $exploded_separate[0];
	// 							// $exp_key[$file_name]['file'] = $exploded_separate[1];
	// 							// $downloadable_files = $exp_key;
	// 						}
	// 					}
	// 					if(!empty($downloads)){
	// 						$product->set_downloads( $downloads );
	// 					}
						
						
	// 					break;
	// 				case 'download_limit':
	// 					$product->set_download_limit($post_values[$post_key]); 
	// 					break;
	// 					case 'download_expiry':	
	// 					$product->set_download_expiry($post_values[$post_key]);
	// 					break;
	// 				case 'crosssell_ids' :
	// 					$crosssellids = '';
	// 					if ($post_values[$post_key]) {
	// 						$exploded_crosssell_ids = explode(',', $post_values[$post_key]);
	// 						$crosssellids = $exploded_crosssell_ids;
	// 					}
	// 					if (is_array($crosssellids) || is_object($crosssellids)){
	// 						foreach($crosssellids as $crosssell_ids){
	// 							if(is_numeric($crosssell_ids)){
	// 								$product_id = $crosssell_ids;	
	// 							}
	// 							else{
	// 								$product_id = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}posts WHERE post_type = 'product' AND post_title = '$crosssell_ids' order by ID Desc ");
	// 							}
	// 							if(!empty($product_id)){
	// 								$crosssell_id[]=$product_id;	
	// 							}
								
	// 						}
	// 						if(!empty($crosssell_id)){
	// 							$product->set_crosssell_ids($crosssell_id);
	// 						}
							
						
						
	// 					}
	// 					break;
	// 				case 'upsell_ids' :
	// 					$upcellids = '';
	// 					if ($post_values[$post_key]) {
	// 						$exploded_upsell_ids = explode(',', $post_values[$post_key]);
	// 						$upcellids = $exploded_upsell_ids;
	// 					}
	// 					if (is_array($upcellids) || is_object($upcellids)){
	// 						foreach($upcellids as $upsell_ids){
	// 							if(is_numeric($upsell_ids)){
	// 								$product_id = $upsell_ids;	
	// 							}
	// 							else{
	// 								$product_id = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}posts WHERE post_type = 'product' AND post_title = '$upsell_ids' order by ID Desc ");
	// 							}
	// 							if(!empty($product_id)){
	// 								$upsell_id[]=$product_id;	
	// 							}
								
	// 						}
	// 						$product->set_upsell_ids($upsell_id);		
					
	// 					}
	// 					break;		
	// 				case 'low_stock_threshold':
	// 					if($post_values[$post_key] !=null){
	// 						$product->set_low_stock_amount($post_values[$post_key]);
	// 					}
	// 					break;		
	// 				case 'sold_individually' :
	// 					if($post_values[$post_key] == 'yes'){
	// 						$product->set_sold_individually( true );
	// 					}
	// 					elseif($post_values[$post_key] == 'no'){
	// 						$product->set_sold_individually(false);
	// 					}
	// 					break;
							  
	// 			}

	// 		}

	// 		if($product_type == 'variation'){
	// 			$helpers_instance = ImportHelpers::getInstance();
	// 			$parentsku = $post_values['parent'];
	// 			$parent_product_id =$wpdb->get_var("SELECT ID from {$wpdb->prefix}posts as p inner join {$wpdb->prefix}postmeta as pm on p.ID=pm.post_id where pm.meta_key='_sku' and pm.meta_value='$parent_sku'");
	// 			$product->set_parent_id($parent_product_id);

	// 			$attr_data =array();
	// 			foreach($attr_meta_data as $attr_value){
	// 				$attr_data[] = $helpers_instance->get_header_values($attr_value,$header_array,$value_array);
	// 			}
	// 			foreach($attr_data as $attr_k => $attr_value){
	// 				foreach($attr_value as $attr_key => $attr_val){
	// 					$i=$attr_k+1;
						
	// 					foreach($attr_value as $attr_key => $attr_val){
	// 						switch($attr_key){
	// 							case "product_attribute_name$i":
	// 								$attr_name =$attr_val;
	// 								break;
	// 							case "product_attribute_value$i":
	// 	// $attribute->set_options( array( 'Yes', 'No' ) );
	// 								$attr_value =$attr_val;
	// 								// $value= explode(',',$attr_val);
	// 								// $attribute->set_options($value);
	// 								break;
	// 							case  "product_attribute_visible$i":
	// 								// $attribute->set_visible( true );
	// 								break;
	
	// 						}
	// 					}
	// 					$product->set_default_attributes( array( $attr_name => $attr_value ) );
	// 					//   
	// 					// $product->set_manage_stock( true ); 
						
	// 				}
	// 			}
			
	// 		}
	// 		if(!empty($attr_meta_data) && $product_type !='variation'){
	// 			$helpers_instance = ImportHelpers::getInstance();
				
	// 			$attr_data =array();
	// 			foreach($attr_meta_data as $attr_value){
	// 				$attr_data[] = $helpers_instance->get_header_values($attr_value,$header_array,$value_array);
	// 			}
	// 			foreach($attr_data as $attr_k => $attr_value){
	// 				$attribute = new \WC_Product_Attribute();
	// 				$i=$attr_k+1;
	// 				foreach($attr_value as $attr_key => $attr_val){
	// 					switch($attr_key){
	// 						case "product_attribute_name$i":
	// 							$attribute->set_name($attr_val);
	// 							break;
	// 						case "product_attribute_value$i":
	// 							$value= explode(',',$attr_val);
	// 							$attribute->set_options($value);
	// 							break;
	// 						case  "product_attribute_visible$i":
	// 							$attribute->set_visible( true );
	// 							break;
   
	// 					}
	// 				}

    // 				$attribute->set_position( 0 );
	// 				$attribute->set_variation( true );
					
	// 				$attributes[] = $attribute;
					
	// 			}
	// 			$product->set_attributes( $attributes ) ;
	// 		}
			
	// 		$product_id = $product->save();
						
	// 	}
	// 	$returnArr['ID'] = $product_id;
	// 	$returnArr['MODE'] = $mode_of_affect;
	// 	$returnArr['post_type'] = $post_type;
	// 	if (!empty($data_array['post_author'])) {
	// 		$returnArr['AUTHOR'] = isset($assigned_author) ? $assigned_author : '';
	// 	}
	// 	return $returnArr;

	// }
}