<?php
/******************************************************************************************
 * Copyright (C) Smackcoders. - All Rights Reserved under Smackcoders Proprietary License
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 * You can contact Smackcoders at email address info@smackcoders.com.
 *******************************************************************************************/

namespace Smackcoders\WCSV;

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

class ProductAttributeExtension extends ExtensionHandler{
	private static $instance = null;

    public static function getInstance() {	
		if (ProductAttributeExtension::$instance == null) {
			ProductAttributeExtension::$instance = new ProductAttributeExtension;
		}
		return ProductAttributeExtension::$instance;
    }

	/**
	* Provides Product Attribute mapping fields
	* @param string $data - selected import type
	* @return array - mapping fields
	*/
    public function processExtension($data,$process_type=null) {
		global $wpdb;

        $response = [];
		$import_type = $data;
		$import_type = $this->import_type_as($import_type);
		$importas = $this->import_post_types($import_type);	
		$taxonomies = get_object_taxonomies( $importas, 'names' );
		// $count=0;
		// $product_statuses = array('publish', 'draft', 'future', 'private', 'pending');
		// $products = wc_get_products(array('status' => $product_statuses , 'limit' => -1));
		// $variable_product_ids = [];
		// foreach($products as $product){
			
		// 	if (($product->is_type('variable'))) {
		// 		$variable_product_ids[] = $product->get_id();
		// 	}
		// }
		// $variation_id = [];
		// foreach($variable_product_ids as $variable_product_id){
		
		// 	if(!empty($variable_product_id)){
		// 		$variable_product = wc_get_product($variable_product_id);
		// 		$variation_id [] = $variable_product->get_children();
		// 	}
			
		// } 
		// foreach($variation_id as $variation_ids){
		// 	if(!empty($variation_ids)){
		// 		$data = wc_get_product($variation_ids[0]);
		// 		$product_attributes=$data->get_attributes();
		// 		$attribute_name = array();  
		// 		foreach ($product_attributes as $attribute_key => $attribute) {
		// 			$attribute_name[]= str_replace('pa_', '',$attribute_key);	
		// 		}
		// 		$attribute_count = count($attribute_name);
		// 		if($attribute_count > $count){
		// 			$count = $attribute_count;
		// 		}
		// 	}
			
		// }
		// if($count ==0){
		// 	$count =1;
		// }
	// if($process_type == 'Export'){
	// 	$pro_attr_fields =array();
	// 	for($i=1; $i<=$count;$i++){
	// 		$pro_attr_fields += array(
	// 			'Product Attribute Name' . $i => 'product_attribute_name' . $i,
	// 			'Product Attribute Value' . $i => 'product_attribute_value' . $i,
	// 			'Product Attribute Visible' . $i => 'product_attribute_visible' . $i
	// 		);
	// 	}
	// 	$pro_attr_fields_line = $this->convert_static_fields_to_array($pro_attr_fields);
	// 	$response['product_attr_fields'] = $pro_attr_fields_line; 
	// }
	// else{
	// 	$pro_attr_fields =array();
	// 	for($i=1; $i<=$count;$i++){
	// 		$pro_attr_fields[]= $this->convert_static_fields_to_array(array(
	// 			"Product Attribute Name$i" => "product_attribute_name$i",
	// 				"Product Attribute Value$i" => "product_attribute_value$i",
	// 				"Product Attribute Visible$i" => "product_attribute_visible$i",
	// 		));
	// 	}
	// 	$response['product_attr_fields'] = $pro_attr_fields; 
	// }
	
	// $attributecount = count($attribute_name);
        $pro_attr_fields = array(
            'Product Attribute Name' => 'product_attribute_name',
            'Product Attribute Value' => 'product_attribute_value',
            'Product Attribute Visible' => 'product_attribute_visible',
            'Product Attribute Variation' => 'product_attribute_variation',
            'Product Attribute Position' => 'product_attribute_position',
            'Product Attribute Taxonomy' => 'product_attribute_taxonomy',
			
        );

		if($import_type == 'WooCommerceVariations'){
			unset($pro_attr_fields['Product Attribute Taxonomy']);
		}

        // if(!empty($taxonomies)) {
		// 	foreach ($taxonomies as $key => $value) {
		// 		$check_for_pro_attr = explode('_', $value);
		// 		if($check_for_pro_attr[0] == 'pa'){	
        //             $get_taxonomy_label = get_taxonomy($value);
        //             $taxonomy_label = $get_taxonomy_label->name;

        //             $pro_attr_fields[$taxonomy_label] = $value;
		// 		}
        //     }
        // }
		$pro_attr_fields_line = $this->convert_static_fields_to_array($pro_attr_fields);
		$response['product_attr_fields'] = $pro_attr_fields_line; 
		return $response;	
	}
	
	/**
	* Product Attribute extension supported import types
	* @param string $import_type - selected import type
	* @return boolean
	*/
	public function extensionSupportedImportType($import_type){
		if(is_plugin_active('woocommerce/woocommerce.php')){
			$import_type = $this->import_name_as($import_type);
			if($import_type == 'WooCommerce' || $import_type == 'WooCommerceVariations' ) { 
				return true;
			}else{
				return false;
			}
		}
	}
}