<?php

use NinjaForms\Includes\Entities\MetaboxOutputEntity;


class NF_Stripe_Checkout_Admin_Metaboxes_MetaboxEntityPaymentStatus
{

    public function handle($extraValue, $nfSub): ?MetaboxOutputEntity
    {
        $return = null;

        // If payment status is not set, there is nothing to display
        // If it is set, then dislay all values to contain within one metabox
        if (!$nfSub->get_extra_value('stripe_payment_status')) {
            return $return;
        }

        $labelValueCollection = self::extractResponses($nfSub);

        if (!empty($labelValueCollection)) {

            $array = [
                'title' => __( 'Stripe Payment', 'ninja-forms' ),
                'labelValueCollection' => $labelValueCollection

            ];

            $return = MetaboxOutputEntity::fromArray($array);
        }

        return $return;
    }

    /**
     * Extract all extra data to be displayed
     *
     * @param [type] $nfSub
     * @return array
     */
    protected  static function extractResponses($nfSub): array
    {

        $return = [];
        if (!$nfSub->get_extra_value('stripe_live')) {
            $return[] = [
                'label' =>'',
                'value' => __( "This is a test transaction.", "ninja-forms-stripe" ),
                'styling' => 'alert'
            ];
        }

        $return[] = [
            'label' => __( "Payment Status", "ninja-forms-stripe" ),
            'value' => $nfSub->get_extra_value('stripe_payment_status'),
            'styling' => ''
        ];

        if ($nfSub->get_extra_value('stripe_token')) {
            $return[] = [
                'label' =>__( "Token", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_token'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_customer_id')) {
            $return[] = [
                'label' =>__( "Customer ID", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_customer_id'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_charge_id')) {
            $return[] = [
                'label' => __( "Charge ID", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_charge_id'),
                'styling' => ''
            ];
        }
        
        if ($nfSub->get_extra_value('stripe_subscription_id')) {

            $return[] = [
                'label' => __( "Subscription ID", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_subscription_id'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_last_four')) {

            $return[] = [
                'label' =>  __("Card", "ninja-forms-stripe"),
                'value' => $nfSub->get_extra_value('stripe_brand'),
                'styling' => ''
            ];

            $return[] = [
                'label' => __("Last 4", "ninja-forms-stripe"),
                'value' => '**** **** **** ' . $nfSub->get_extra_value('stripe_last_four'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_error')) {

            $return[] = [
                'label' => __( "Error Response", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_error'),
                'styling' => 'alert'
            ];
        }

        return $return;
    }

}
