<?php if ( ! defined( 'ABSPATH' ) ) exit;

return apply_filters( 'nf_payeezy_plugin_settings', array(

	'payeezy_setting_info' => array(
        'id'    => 'payeezy_setting_info',
		'type'  => 'html',
        'label' => __( 'API Credentials', 'nf-payeezy' ),
		'html'  => sprintf( __( '<a href="%s" target="_blank">Click here</a> to go to the sales page and check under the <strong>"API Credentials"</strong> tab for instructions to generate API credentials.', 'nf-payeezy' ), 'https://wpgateways.com/products/payeezy-first-data-gateway-ninja-forms/' ),
    ),

	'payeezy_test_mode' => array(
        'id' 	=> 'payeezy_test_mode',
        'type' 	=> 'checkbox',
        'label' => __( 'Demo Mode', 'nf-payeezy' ),
        'desc' 	=> __( 'Use Payeezy demo credentials to test transaction.', 'nf-payeezy' ),
    ),

    'payeezy_api_key' => array(
        'id'    => 'payeezy_api_key',
        'type'  => 'textbox',
        'label' => __( 'API Key', 'nf-payeezy' ),
		'desc'  => esc_html__( 'Get it from the APIs page. Please make sure it belongs to the mode you selected above.', 'nf-payeezy' ),
    ),

    'payeezy_api_secret' => array(
        'id'    => 'payeezy_api_secret',
        'type'  => 'textbox',
        'label' => __( 'API Secret', 'nf-payeezy' ),
		'desc'  => esc_html__( 'Get it from the APIs page. Please make sure it belongs to the mode you selected above.', 'nf-payeezy' ),
    ),

    'payeezy_merchant_token' => array(
        'id'    => 'payeezy_merchant_token',
        'type'  => 'textbox',
        'label' => __( 'Merchant Token', 'nf-payeezy' ),
		'desc'  => esc_html__( 'The Token from the Merchants page. Not to be confused with "Merchant ID". Please make sure the Merchant is "Approved" in the mode you selected above.', 'nf-payeezy' ),
    ),

));
