<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_Payeezy_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox {
    public function __construct() {
        parent::__construct();
        $this->_title = __( 'Payeezy Payment', 'nf-payeezy' );

		if( $this->sub && ! $this->sub->get_extra_value( 'payeezy_charge_id' ) != null ){
            remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        }
    }

    public function render_metabox( $post, $metabox ) {
        if( $this->sub->get_extra_value( 'payeezy_charge_id' ) ) {
            if( ! $this->sub->get_extra_value( 'payeezy_live' ) ) {
                echo "<div style='text-align: center; background-color: yellow;'>";
                echo "<strong>";
                echo __( "This is a test transaction.", "nf-payeezy" );
                echo "</strong>";
                echo "</div>";
            }

            echo "<dl>";

            echo "<dt>";
            echo __( "Charge ID", "nf-payeezy" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'payeezy_charge_id' );
            echo "</dd>";

            echo "<dt>";
            echo __( "Card", "nf-payeezy" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'payeezy_brand' );
            echo "</dd>";
            echo "<dd>";
            echo "**** **** **** ";
            echo $this->sub->get_extra_value( 'payeezy_last4' );
            echo "</dd>";

            echo "</dl>";
        } else {
            echo "<div style='text-align: center; background-color: yellow;'>";
            echo "<strong>";
            echo __( "Not charged using this gateway.", "nf-payeezy" );
            echo "</strong>";
            echo "</div>";
        }

    }
}