<?php

/*
 * Plugin Name: Ninja Forms - Payeezy (First Data) Gateway
 * Plugin URI: https://wpgateways.com/product/payeezy-first-data-gateway-ninja-forms/
 * Description: Integrates Ninja Forms with Payeezy from First Data, enabling end users to purchase goods and services through Ninja Forms.
 * Version: 3.0.1
 * Author: WP Gateways
 * Author URI: https://wpgateways.com
 * Text Domain: nf-payeezy
 * Domain Path: /languages/
 *
*/

include plugin_dir_path( __FILE__ ) . 'includes/deprecated.php';

/**
 * Class NF_Payeezy
 */
final class NF_Payeezy {

    const VERSION = '3.0.1';
    const SLUG    = 'payeezy';
    const NAME    = 'Payeezy';
    const AUTHOR  = 'WP Gateways';
    const PREFIX  = 'NF_Payeezy';

    /**
     * @var NF_Payeezy
     * @since 3.0
     */
    private static $instance;

    /**
     * Plugin Directory
     *
     * @since 3.0
     * @var string $dir
     */
    public static $dir = '';

    /**
     * Plugin URL
     *
     * @since 3.0
     * @var string $url
     */
    public static $url = '';

    /**
     * Main Plugin Instance
     *
     * Insures that only one instance of a plugin class exists in memory at any one
     * time. Also prevents needing to define globals all over the place.
     *
     * @since 3.0
     * @static
     * @static var array $instance
     * @return NF_Payeezy Highlander Instance
     */
    public static function instance() {
        if( ! isset( self::$instance ) && ! ( self::$instance instanceof NF_Payeezy ) ) {
            self::$instance = new NF_Payeezy();

            self::$dir = plugin_dir_path( __FILE__ );

            self::$url = plugin_dir_url( __FILE__ );

            /*
             * Register our autoloader
             */
            spl_autoload_register( array( self::$instance, 'autoloader' ) );
        }
    }

    public function __construct() {
        load_plugin_textdomain( 'nf-payeezy', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
        add_filter( 'ninja_forms_enable_credit_card_fields', '__return_true' );
        add_action( 'ninja_forms_loaded', array( $this, 'setup_admin' ), 11 );
        add_filter( 'ninja_forms_register_payment_gateways', array( $this, 'register_payment_gateways' ) );
    }

    /**
     * Setup Admin
     *
     * Setup admin classes for Ninja Forms and WordPress.
     */
    public function setup_admin() {
        if( ! is_admin() ) return;

		include self::$dir . 'updates/updates.php';

		if( !array_key_exists( 'creditcard', Ninja_Forms()->fields ) ) {
            Ninja_Forms()->fields[ 'creditcard' ] = new NF_Fields_CreditCard();
        }

        new NF_Payeezy_Admin_Settings();
        new NF_Payeezy_Admin_Metaboxes_Submission();
    }

    /**
     * Register Payment Gateways
     *
     * Register payment gateways with the Collect Payment action.
     *
     * @param array $payment_gateways
     * @return array $payment_gateways
     */
    public function register_payment_gateways( $payment_gateways ) {
        $payment_gateways[ 'payeezy' ] = new NF_Payeezy_PaymentGateway();
        return $payment_gateways;
    }

    /**
     * Template
     *
     * @param string $file_name
     * @param array $data
     */
    public static function template( $file_name = '', array $data = array() ) {
        if( ! $file_name ) return;

        extract( $data );

        include self::$dir . 'includes/Templates/' . $file_name;
    }

    /**
     * Config
     *
     * @param $file_name
     * @return mixed
     */
    public static function config( $file_name ) {
        return include self::$dir . 'includes/Config/' . $file_name . '.php';
    }

    /**
     * Autoloader
     *
     * Loads files using the class name to mimic the folder structure.
     *
     * @param $class_name
     */
    public function autoloader( $class_name ) {
        if( class_exists( $class_name ) ) return;

        if ( false === strpos( $class_name, self::PREFIX ) ) return;

        $class_name = str_replace( self::PREFIX, '', $class_name );
        $classes_dir = realpath( plugin_dir_path( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
        $class_file = str_replace( '_', DIRECTORY_SEPARATOR, $class_name) . '.php';

        if ( file_exists( $classes_dir . $class_file ) ) {
            require_once $classes_dir . $class_file;
        }
    }

}

/**
 * The main function responsible for returning The Highlander Plugin
 * Instance to functions everywhere.
 *
 * Use this function like you would a global variable, except without needing
 * to declare the global.
 *
 * @since 3.0
 * @return NF_Payeezy Highlander Instance
 */
function NF_Payeezy() {
    return NF_Payeezy::instance();
}

NF_Payeezy();