<?php

namespace DCTheme\Elementor;


class RemovePageTitles {

    public function __construct()
    {
        add_filter('hello_elementor_page_title', [$this, 'remove_titles']);
    }


    public function remove_titles(): bool
    {
        if (is_elementor()) {
            return false;
        }

        return true;
    }


}


/**
 * Determines if any given post was created using Elementor
 * Used in template and when loading scripts.
 */
function is_elementor(){

    global $post;

    if (!$post) {
        return false;
    }

    $document = \Elementor\Plugin::$instance->documents->get($post->ID);

    if (!$document) {
        return false;
    }

    return $document->is_built_with_elementor();
}