<?php
namespace Deployer;

define('SITE', '---SITE---');
define('SITE_SSH_USER', '---SSHUSER---');



require 'recipe/common.php';

// Project name
set('application', SITE);
set('keep_releases', 3);

// Project repository
set('repository', 'git@gitlab.com:dojocreative/'.SITE.'.git');

// [Optional] Allocate tty for git clone. Default value is false.
set('git_tty', true);

// Shared files/dirs between deploys
set('shared_files', [
    '.env',
    //'auth.json',
    'html/.htaccess'
]);

set('shared_dirs', [
    'html/content/uploads',
]);

// Writable dirs by web server
set('writable_dirs', []);
set('allow_anonymous_stats', false);

// Hosts
host('ded808.letsgodojo.com')
    ->user(SITE_SSH_USER)
    ->set('deploy_path', '~/{{application}}');


// Tasks
desc('gulp.js Building Production');
task('deploy:gulp', './node_modules/gulp/bin/gulp.js production');

desc('Install Node Modules');
task('deploy:npm', 'npm install');


desc('Deploy your project');
task('deploy', [
    'deploy:info',
    'deploy:prepare',
    'deploy:lock',
    'deploy:release',
    'deploy:update_code',
    'deploy:shared',
    'deploy:writable',
    'deploy:vendors',
    'deploy:npm',
    'deploy:gulp',
    'deploy:clear_paths',
    'deploy:symlink',
    'deploy:unlock',
    'cleanup',
    'success'
]);

// [Optional] If deploy fails automatically unlock.
after('deploy:failed', 'deploy:unlock');


desc('Sync Live SQL with Local SQL');
task('dev-sync:db-dump', function () {

    run('
        cd {{current_path}}
        wp db export ~/{{application}}/.dep/current.sql
    ');
});

desc('Pulling SQL dump');
task('dev-sync:pull-dump', function () {
    download('~/{{application}}/.dep/current.sql', 'current.sql');
});

desc('Importing Sql dump');
task('dev-sync:db-import', function () {
    runLocally('wp db import current.sql');
});

desc('Cleaning Up');
task('dev-sync:sql-cleanup', function () {
    runLocally('rm current.sql');
    run('rm ~/{{application}}/.dep/current.sql');
});


desc('Pull Remote Files');
task('dev-sync:pullfiles', function () {

    $server = \Deployer\Task\Context::get()->getHost();

    $host = $server->getRealHostname();
    $port = $server->getPort() ? ' -p' . $server->getPort() : '';
    $sshArguments = $server->getSshArguments();
    $user = !$server->getUser() ? '' : $server->getUser() . '@';

    $dst = 'html/content/uploads';
    $src = "~/{{application}}/current/$dst";

    runLocally("rsync -vrz -e 'ssh$port $sshArguments' '$user$host:$src/' '$dst/'", ['tty' => true]);
});

desc('Pull Remote Database');
task('dev-sync', [
    'dev-sync:pullfiles',
    'dev-sync:db-dump',
    'dev-sync:pull-dump',
    'dev-sync:db-import',
    'dev-sync:sql-cleanup'
]);
