<?php

namespace DCTheme\General;


class Shortcodes
{
    public function __construct() {
        add_shortcode('copyright', [$this, 'copyright']);
        add_shortcode('dojo', [$this, 'dojo']);
    }

    public function copyright(): string
    {
        return '&copy;' . date('Y') . ' '.get_bloginfo('title');
    }


    public function dojo($attributes): string
    {
        $attributes = shortcode_atts(array(
            'd' => '#C00',
            'j' => '#FFF'
        ), $attributes, 'dojo');

        $d_color = $attributes['d'];
        $j_color = $attributes['j'];

        $d = '<?xml version="1.0" encoding="utf-8"?>';
        $d .= '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 49.8 61.1">';
        $d .= '<style type="text/css">';
        $d .= '.d-d { fill:' . $d_color . '; }';
        $d .= '.d-j { fill:' . $j_color . '; }';
        $d .= '</style>';
        $d .= '<path class="d-d" d="M29,46.8c-5.4,2.6-11.8,0.4-14.5-4.8c-2.7-5.4-0.5-12,4.9-14.8c3.4-1.8,7.5-1.6,10.8,0.4L22.7,13 c-3.2,0.2-6.4,1.1-9.3,2.6C1.5,21.7-3.3,36.1,2.7,47.9C8.7,59.5,23,64.2,34.9,58.3C34.9,58.3,29,46.8,29,46.8z"/>';
        $d .= '<path class="d-j" d="M45.6,23.5L33.7,0.3H19.2l6.4,12.5l0,0L35.4,32l0,0c2.3,4.9,0.6,10.8-3.9,13.8l5.9,11.6 c11.1-6.4,15.4-20.3,9.6-31.7C46.5,25,46.1,24.3,45.6,23.5z"/>';
        $d .= '</svg>';

        return '<span class="dojo-d"><a href="https://letsgodojo.com">Website</a> by <a href="https://letsgodojo.com" style="display:inline-block; width:1em; vertical-align:middle">' . $d . '</a></span>';
    }


}