<?php

namespace DCTheme\Elementor;


class ContainerStyles
{

    protected array $control_options = [
        '' => 'None',
        'def' => 'Default (White)',
        'dark' => 'Dark Background',
        'light' => 'Light Background'
    ];

    public function __construct()
    {
        add_action('elementor/element/container/section_layout_container/after_section_start', [$this, 'add_style_control']);
    }


    public function add_style_control(\Elementor\Includes\Elements\Container $element): void
    {
        if ('container' === $element->get_name()) {

            $element->add_control('dojo_style', [
                'type' => \Elementor\Controls_Manager::SELECT,
                'label' => 'Content Style',
                'default' => '',
                'options' => $this->control_options,
                'prefix_class' => 'p-con-',
            ]);
        }
    }
}