<?php
namespace Deployer;

include __DIR__.'/vendor/autoload.php';

define('SITE', 'DOMAIN-COM');
define('SITE_SSH_USER', '--ENTER-USER--');


require 'recipe/composer.php';
require 'contrib/npm.php';
require __DIR__.'/vendor/dojointernal/dojo-deploy/recipes/wordpress.php';
require __DIR__.'/vendor/dojointernal/dojo-deploy/recipes/golive.php';

// Project repository
set('repository', 'git@gitlab.com:dojocreative/'.SITE.'.git');

// Shared files/dirs between deploys
add('shared_files', [
    '.env',
    'public/.htaccess',
    'public/wp-content/mu-plugins/licenses.php'
]);

add('shared_dirs', [
    'public/wp-content/uploads',
    'public/wp-content/cache',
]);

// Writable dirs by web server
add('writable_dirs', []);


// Hosts
host('ded808.letsgodojo.com')
    ->set('remote_user', SITE_SSH_USER)
    ->set('deploy_path', '~/'.SITE);

// Tasks
desc('gulp.js Building Production');
task('deploy:gulp', function() {
    cd('{{release_path}}');
    run('./node_modules/gulp/bin/gulp.js production');
});

after('deploy:vendors', 'npm:install');
after('npm:install', 'deploy:gulp');
after('deploy:failed', 'deploy:unlock');