<?php
namespace Deployer;

desc('Update .env Vars');
task('golive:update-env', function () {

    if (is_dir(dirname(__DIR__).'/vendor')) {
        require dirname(__DIR__).'/vendor/autoload.php';
    }

    require dirname(__DIR__).'/src/utils.php';


    cd('{{current_path}}');
    $data = run('cat .env');

    $info = \Dotenv\Dotenv::parse($data);

    // Set our production values
    $info['WP_ENVIRONMENT_TYPE'] = 'production';
    $info['WP_HOME'] = 'https://'.SITE;
    $info['DISALLOW_FILE_EDIT'] = 'true';
    $info['DISALLOW_FILE_MODS'] = 'true';
    $info['WP_POST_REVISIONS'] = '20';

    /// Set our Keys
    $info['AUTH_KEY'] = $info['AUTH_KEY'] ?? generate_random_string(65, "'");
    $info['SECURE_AUTH_KEY'] = $info['SECURE_AUTH_KEY'] ?? generate_random_string(65, "'");
    $info['LOGGED_IN_KEY'] = $info['LOGGED_IN_KEY'] ?? generate_random_string(65, "'");
    $info['NONCE_KEY'] = $info['NONCE_KEY'] ?? generate_random_string(65, "'");
    $info['AUTH_SALT'] = $info['AUTH_SALT'] ?? generate_random_string(65, "'");
    $info['SECURE_AUTH_SALT'] = $info['SECURE_AUTH_SALT'] ?? generate_random_string(65, "'");
    $info['LOGGED_IN_SALT'] = $info['LOGGED_IN_SALT'] ?? generate_random_string(65, "'");
    $info['NONCE_SALT'] = $info['NONCE_SALT'] ?? generate_random_string(65, "'");


    cd('{{deploy_path}}/shared');
    run('cp .env .old.env');
    run('echo "# Live Config" > .env');

    foreach ($info as $key => $value) {
        run('echo "'.$key.'='.$value.'" >> .env');
    }

    cd('{{current_path}}');

    if (test("[ -f .env.cached.php ]")) {
        run('rm .env.cached.php');
    }
});

desc('Set Options');
task('golive:set-options', function () {

    $choices = [
        'America/New_York' => 'America/New_York',
        'America/Chicago' => 'America/Chicago',
        'America/Denver' => 'America/Denver',
        'America/Los_Angeles' => 'America/Los_Angeles',
    ];

    $tz = askChoice('What Timezone?', $choices, 'America/New_York');

    cd('{{current_path}}');
    run('wp option update start_of_week 0');
    run('wp option update users_can_register 0');
    run('wp option update timezone_string '.$tz);
    run('wp cache flush');

});

desc('Search Replace');
task('golive:search-replace', function () {

    $old_url = ask('What is the old URL?');
    $new_url = ask('What is the new URL?', 'https://'.SITE);

    set('old_url', $old_url);
    set('new_url', $new_url);

    cd('{{current_path}}');
    run('wp elementor replace_urls {{old_url}} {{new_url}}');
    run('wp search-replace {{old_url}} {{new_url}} --skip-columns=guid --all-tables');
    run('wp cache flush');

});

desc('Activate/Deactivate Plugins');
task('golive:plugins', function () {

    cd('{{current_path}}');
    run('wp plugin deactivate query-monitor');
    run('wp plugin activate redirection');
    run('wp plugin activate wp-rocket');
    run('wp plugin activate sqlite-object-cache');;
    run('wp cache flush');
});

desc('Go Live');
task('golive', [
    'golive:plugins',
    'golive:set-options',
    'golive:search-replace',
    'golive:update-env',
]);