# dojo-deploy

`dojo-deploy` provides reusable Deployer recipes for WordPress projects.

## Minimal `deploy.php`

Use `recipes/project.php` to keep per-project deploy files short.

### Required settings

- `site`: Production domain (used for defaults like repository/deploy path).
- `ssh_user`: cPanel/SSH user for the host.
- `host_name`: SSH host to deploy to.

### Optional settings

- `staging_domain`: Used by `initial-deploy` tasks.
- `build_command`: If set, runs after `npm:install`.
- `deploy_path`: Overrides default `~/<site>`.
- `repository`: Overrides default `git@gitlab.com:dojocreative/<site>.git`.
- `extra_shared_files`: Extra shared files to merge with defaults.
- `extra_shared_dirs`: Extra shared dirs to merge with defaults.

### Example

```php
<?php
namespace Deployer;

include __DIR__.'/vendor/autoload.php';

set('site', 'grkremodeling.com');
set('ssh_user', 'grkremodeling');
set('host_name', 'ded808.letsgodojo.com');

set('staging_domain', 'grkremodeling.dojocreative.net');
set('build_command', './node_modules/gulp/bin/gulp.js production');
set('extra_shared_files', [
    'public/llms.txt',
]);

require __DIR__.'/vendor/dojointernal/dojo-deploy/recipes/project.php';
```
