<?php

function generate_random_string(int $length = 65, $wrap = '', $limit_special_chars = false): string
{
    $full_characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*()-_+=[]{}|;:,.<>?';
    $limited_characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@#$%';
    $characters = $limit_special_chars ? $limited_characters : $full_characters;

    $randomString = '';
    $charactersLength = strlen($characters);

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }

    return $wrap.$randomString.$wrap;
}


function set_if_empty(&$array, $key, $value)
{
    if (empty($array[$key])) {
        $array[$key] = $value;
    }
}