<?php

namespace Deployer;

require 'recipe/composer.php';
require 'contrib/npm.php';

require __DIR__.'/wordpress.php';
require __DIR__.'/golive.php';
require __DIR__.'/initial-deploy.php';

$site = has('site') ? (string) get('site') : (defined('SITE') ? (string) SITE : '');
if ($site === '') {
    throw new \RuntimeException("Missing site configuration. Set `set('site', 'example.com')` in deploy.php.");
}

if (!defined('SITE')) {
    define('SITE', $site);
}

$sshUser = has('ssh_user')
    ? (string) get('ssh_user')
    : (defined('SITE_SSH_USER') ? (string) SITE_SSH_USER : '');
if ($sshUser === '') {
    throw new \RuntimeException("Missing ssh user configuration. Set `set('ssh_user', 'cpaneluser')` in deploy.php.");
}

if (!defined('SITE_SSH_USER')) {
    define('SITE_SSH_USER', $sshUser);
}

if (!has('repository')) {
    set('repository', 'git@gitlab.com:dojocreative/'.$site.'.git');
}

add('shared_files', [
    '.env',
    'public/.htaccess',
    'public/wp-content/mu-plugins/licenses.php',
    'public/llms.txt'
]);

add('shared_dirs', [
    'public/wp-content/uploads',
    'public/wp-content/cache',
]);

if (has('extra_shared_files')) {
    $extraSharedFiles = get('extra_shared_files');
    if (is_array($extraSharedFiles) && !empty($extraSharedFiles)) {
        add('shared_files', $extraSharedFiles);
    }
}

if (has('extra_shared_dirs')) {
    $extraSharedDirs = get('extra_shared_dirs');
    if (is_array($extraSharedDirs) && !empty($extraSharedDirs)) {
        add('shared_dirs', $extraSharedDirs);
    }
}

if (!has('writable_dirs')) {
    set('writable_dirs', []);
}

$hostName = has('host_name') ? (string) get('host_name') : '';
if ($hostName === '') {
    throw new \RuntimeException("Missing host name configuration. Set `set('host_name', 'server.example.com')` in deploy.php.");
}

host($hostName)
    ->set('remote_user', $sshUser)
    ->set('deploy_path', has('deploy_path') ? (string) get('deploy_path') : '~/'.$site);

if (has('build_command') && trim((string) get('build_command')) !== '') {
    desc('Install npm deps and run frontend build command when package.json exists');
    task('deploy:build-assets', function () {
        if (!test('[ -f {{release_path}}/package.json ]')) {
            writeln('<comment>Skipping npm/build: no package.json in release.</comment>');
            return;
        }

        invoke('npm:install');
        cd('{{release_path}}');
        run((string) get('build_command'));
    });

    after('deploy:vendors', 'deploy:build-assets');
}

after('deploy:failed', 'deploy:unlock');
