<?php

set('wordpress_content_dir', 'public/wp-content');

desc('Pull Remote Files');
task('dev-sync:pull-files', function () {

    $server = \Deployer\Task\Context::get()->getHost();

    $host = $server->getRealHostname();
    $port = $server->getPort() ? ' -p' . $server->getPort() : '';
    $sshArguments = $server->getSshArguments();
    $user = !$server->getUser() ? '' : $server->getUser() . '@';

    runLocally("rsync -vrz -e 'ssh$port $sshArguments' '$user$host:~/{{application}}/current/{{wordpress_content_dir}}' '{{wordpress_content_dir}}/'", ['tty' => true]);
});


desc('Sync Live SQL with Local SQL');
task('dev-sync:db-dump', function () {

    run('
        cd {{current_path}}
        wp db export ~/{{application}}/.dep/current.sql
    ');
});

desc('Pulling SQL dump');
task('dev-sync:pull-dump', function () {
    download('~/{{application}}/.dep/current.sql', 'current.sql');
});

desc('Importing Sql dump');
task('dev-sync:db-import', function () {
    runLocally('wp db import current.sql');
});

desc('Cleaning Up');
task('dev-sync:sql-cleanup', function () {
    runLocally('rm current.sql');
    run('rm ~/{{application}}/.dep/current.sql');
});


desc('Pull Remote Database');
task('dev-sync:pull-database', [
    'dev-sync:db-dump',
    'dev-sync:pull-dump',
    'dev-sync:db-import',
    'dev-sync:sql-cleanup'
]);


desc('Pull Remote Site');
task('dev-sync', [
    'dev-sync:pull-files',
    'dev-sync:pull-database'
]);
