<?php

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

global $woocommerce;
$items = $woocommerce->cart->get_cart();
$dojomc_options = get_option( 'dojomc_options' );
$minicart_icon = $dojomc_options['minicart-icon'];
if( $minicart_icon == 'dojomc-icon-1' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-1.svg';
elseif( $minicart_icon == 'dojomc-icon-2' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-2.png';
elseif( $minicart_icon == 'dojomc-icon-3' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-3.png';
elseif( $minicart_icon == 'dojomc-icon-4' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-4.png';
elseif( $minicart_icon == 'dojomc-icon-5' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-5.png';
elseif( $minicart_icon == 'dojomc-icon-6' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-6.png';
elseif( $minicart_icon == 'dojomc-icon-7' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-7.png';
elseif( $minicart_icon == 'dojomc-icon-8' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-8.png';
elseif( $minicart_icon == 'dojomc-icon-9' ) :
	$icon = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/graphics/dojomc-icon-9.png';
endif;
?>
<div class="dojomc-cart-wrapper">
	<a class="dojomc-cart">
		<?php //echo $icon; ?>
		<img src="<?php echo $icon; ?>" alt="Mini Cart" width="50" height="50" >
		<span class="dojomc-count"><?php echo $woocommerce->cart->cart_contents_count; ?></span>
	</a>
	<?php if( $items ) : ?>
		<div class="dojomc-content">
			<h3><?php printf( __('You have %d items in cart', 'dojo-minicart'), $woocommerce->cart->cart_contents_count); ?></h3>
			<ul class="dojomc-products">
				<?php foreach($items as $item => $values) {  
					$_product =  wc_get_product( $values['data']->get_id() );
				//echo $_product; 
					?>
					<li>
						<div class="dojomc-remove">
							<?php
								// @codingStandardsIgnoreLine
							echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
								'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
								esc_url( wc_get_cart_remove_url( $item ) ),
								__( 'Remove this item', 'dojo-minicart' ),
								esc_attr( $_product ),
								esc_attr( wc_get_product( $values['data']->get_id() )->get_sku() )
							), $item );
							?>
						</div>
						<div class="dojomc-image">
							<?php
							$getProductDetail = wc_get_product( $values['product_id'] );
							?>
							<a href="<?php echo $_product->get_permalink(); ?>">
								<?php echo $getProductDetail->get_image(); ?>
							</a>
						</div>	
						<div class="dojomc-details">
							<a class="dojomc-product-title" href="<?php echo $_product->get_permalink(); ?>">
								<h4><?php echo $_product->get_title() ?></h4>
							</a>
							<?php
							$price      = $_product->get_price_html();
							?>
							<p>
								<?php echo '<span class="dojomc-price">'. $price .'</span> x '. $values["quantity"]; ?>
							</p>
						</div>
					</li>
				<?php } ?>
			</ul>
			<div class="dojomc-subtotal">
				<h5><?php _e( 'Subtotal:&nbsp;', 'dojo-minicart' ); echo $woocommerce->cart->get_cart_subtotal(); ?></h5>
			</div>
			<div class="dojomc-bottom-buttons">
				<a href="<?php echo wc_get_cart_url(); ?>" class="btn"><?php _e( 'View Cart', 'dojo-minicart' ) ?></a>
				<a href="<?php echo wc_get_checkout_url(); ?>" class="btn"><?php _e( 'Checkout', 'dojo-minicart' ) ?></a>
			</div>
		</div>
		<?php else: ?>
			<div class="dojomc-content dojomc-empty">
				<h3><?php  _e('Your cart is empty.', 'dojo-minicart'); ?></h3>
			<?php endif; ?>
		</div>
	</div>