<?php
/**
 * Plugin Name:       Dojo Minicart
 * Description:       The simple plugin to add Minicart on your WooCommerce website.
 * Version:           1.0.0
 * Author:            Dojo Creative
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       dojo-minicart
*/

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Activation Hook.
 */
register_activation_hook( __FILE__, 'dojomc_activate' );
function dojomc_activate(){
	$default = array(
		'enable-minicart'        => 1,
		'minicart-icon'          => 'dojomc-icon-1',
		'minicart-position'      => 'dojomc-top-right',
		'dojomc-offset'             => 150 
	);
	add_option( 'dojomc_options', $default, '', 'yes' );
}

/**
 * Deactivation Hook.
 */
register_deactivation_hook( __FILE__, 'dojomc_deactivate' );
function dojomc_deactivate(){
}

/**
 * Admin notice if WooCommerce not installed and activated.
 */
function dojomc_no_woocommerce(){ ?>
		<div class="error">
				<p><?php _e( 'Dojo Minicart Plugin is activated but not effective. It requires WooCommerce in order to work.', 'dojo-minicart' ); ?></p>
			</div>
<?php	
}

/**
 *  Main Class
 */
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

require plugin_dir_path( __FILE__ ) . 'class-dojo-minicart.php';

new DOJOMC_Main_Class();

}

else{
	add_action( 'admin_notices', 'dojomc_no_woocommerce' );
}

//Add settings link on plugin page
function dojomc_settings_link($links) { 
  $settings_link = '<a href="admin.php?page=dojo-minicart">Settings</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}
 
$plugin = plugin_basename(__FILE__); 
add_filter("plugin_action_links_$plugin", 'dojomc_settings_link' );

add_action( 'init', 'dojomc_load_textdomain' );
  
//Load plugin textdomain.
function dojomc_load_textdomain() {
  load_plugin_textdomain( 'dojomc_textdomain', false, dirname( plugin_basename( __FILE__ ) ) . '/lang' ); 
}