<?php

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

class DOJOMC_Main_Class{

    public $dojomc_options;
    public $plugin_version;

	public function __construct(){
        $this->plugin_version = '1.0.0';
        $this->dojomc_options = get_option( 'dojomc_options' );
		add_action( 'admin_menu', array( $this, 'dojomc_admin_menu' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
        if( $this->dojomc_options['enable-minicart'] == 1 ) {
		add_action( 'wp_footer', array( $this, 'templates' ) );
		add_filter( 'woocommerce_add_to_cart_fragments', array( $this, 'dojomc_fragments' ), 30, 1);
		add_action( 'wp_enqueue_scripts', array( $this, 'scripts' ) );
        add_action( 'wp_head', array( $this, 'dynamic_css' ) );
    }
	}

	public function scripts(){
		wp_enqueue_style( 'dojomc-template1', plugins_url( '/assets/css/dojomc-default-template.css', __FILE__ ), '', $this->plugin_version );
        wp_enqueue_script( 'dojomc-js', plugins_url('/assets/js/dojo-minicart.js', __FILE__), 'jQuery', $this->plugin_version, true );
	}

    public function admin_scripts($hook){
        if($hook != 'toplevel_page_dojo-minicart') {
               return;
        }
        wp_enqueue_style( 'dojomc-admin-css', plugins_url('/assets/css/admin.css', __FILE__), '', $this->plugin_version );
        wp_enqueue_script( 'dojomc-admin-js', plugins_url('/assets/js/admin.js', __FILE__), 'jQuery', $this->plugin_version, true );
    }

	public function templates(){
		if( !is_cart() && !is_checkout() ){
		  require plugin_dir_path( __FILE__ ) . '/frontend/dojomc-default-template.php';
		}
	}


	public function dojomc_fragments( $fragments ){
		ob_start();
		require plugin_dir_path( __FILE__ ) . '/frontend/dojomc-default-fragment.php';
		$fragments['div.dojomc-content'] = ob_get_clean();
		$fragments['span.dojomc-count'] = '<span class="dojomc-count">'. $woocommerce->cart->cart_contents_count .'</span>';
		return $fragments;
	}

    public function dynamic_css(){
        $minicart_position = $this->dojomc_options['minicart-position']; 
        $dojomc_offset        = $this->dojomc_options['dojomc-offset'];
        ?>
        <style type="text/css">
        <?php if( $minicart_position == 'dojomc-top-left' ) : ?>
            .dojomc-cart-wrapper{
                left: 50px;
                top: <?php echo $dojomc_offset; ?>px;
            }
            .dojomc-cart{
                left: 10px;
            }
        <?php elseif( $minicart_position == 'dojomc-top-right' ) : ?>
            .dojomc-cart-wrapper{
                right: 50px;
                top: <?php echo $dojomc_offset; ?>px;
            }
            .dojomc-cart{
                right: 10px;
            }
        <?php elseif( $minicart_position == 'dojomc-bottom-left' ) : ?>
            .dojomc-cart-wrapper{
                left: 50px;
                bottom: 100px;
            }
            .dojomc-cart{
                left: 10px;
            }
            .dojomc-content{
                position: fixed;
                bottom: 100px;
                top: unset;
                right: unset;
            }
        <?php elseif( $minicart_position == 'dojomc-bottom-right' ) : ?>
            .dojomc-cart-wrapper{
                right: 50px;
                bottom: 100px;
            }
            .dojomc-cart{
                right: 10px;
            }
            .dojomc-content{
                position: fixed;
                bottom: 100px;
                top: unset;
            }
        <?php endif; ?>
        </style>
    <?php }

    public function dojomc_admin_menu(){
    	add_menu_page(
        __( 'Minicart Options', 'dojo-minicart' ),
        __( 'Dojo Minicart', 'dojo-minicart' ),
        'manage_options',
        'dojo-minicart',
        array( $this, 'dojomc_admin_menu_callback' ),
        'dashicons-cart',
        59
    );
    }

    public function dojomc_admin_menu_callback(){
    	require plugin_dir_path( __FILE__ ) . '/admin/dojomc-admin.php';
    }
}