<?php

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

if (!current_user_can('activate_plugins')) {
	wp_die(_e('You do not have sufficient permissions to access this page.', 'dojo-minicart'));
}

$plugin_version  = '1.0.0';

if (!empty($_POST) && check_admin_referer('dojomc-afs', 'dojomc-admin-nonce')) {
	$data = array(
		'enable-minicart'   => (isset($_POST['enable-minicart']) ? '1' : '0'),
		'minicart-icon'     => sanitize_text_field($_POST['minicart-icon']),
		'minicart-position' => sanitize_text_field($_POST['minicart-position']),
		'dojomc-offset'        => absint($_POST['dojomc-offset'])
	);
	update_option('dojomc_options', $data);
}

$current_options = get_option('dojomc_options');
//print_r($current_options);

?>
<div class="wrap dojomc-wrap">
	<h1 class="hidden-h1"></h1>
	<?php if (isset($_POST['dojomc_option_submit'])) { ?>
		<div class="notice notice-success">
			<p><strong>Settings saved.</strong></p>
		</div>
	<?php } ?>
	<div class="dojomc-admin-page-title">
		<h1 class="dojomc-admin-title"><?php echo get_admin_page_title(); ?></h1>
		<span class="dojomc-version"><?php echo $plugin_version; ?></span>
	</div>
	<form method="POST" class="options-form">

		<?php wp_nonce_field('dojomc-afs', 'dojomc-admin-nonce'); ?>

		<div class="block">
			<fieldset>
				<legend class="screen-reader-text"><span>
						<?php _e('Enable Minicart', 'dojo-minicart'); ?>
					</span></legend>
				<label for="enable-minicart">
					<input name="enable-minicart" type="checkbox" <?php if ($current_options['enable-minicart'] == 1) : ?> checked <?php endif; ?> />
					<span><?php _e('Enable Minicart', 'dojo-minicart'); ?></span>
				</label>
			</fieldset>
		</div>

		<div class="block">
			<h3><?php _e('Minicart Icon', 'dojo-minicart'); ?></h3>
			<fieldset>
				<legend class="screen-reader-text"><span><?php _e('Cart Icons', 'dojo-minicart') ?></span></legend>

				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-1" data-class="minicart-1" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-1') : echo 'checked';
																											endif; ?> />
					<span>
						<img class="minicart-1 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-1') : echo 'cart-active';
												endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-1.svg' ?>" alt="Mini Cart" width="50" height="50">
					</span>
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-2" data-class="minicart-2" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-2') : echo 'checked';
																											endif; ?> />
					<img class="minicart-2 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-2') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-2.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-3" data-class="minicart-3" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-3') : echo 'checked';
																											endif; ?> />
					<img class="minicart-3 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-3') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-3.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-4" data-class="minicart-4" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-4') : echo 'checked';
																											endif; ?> />
					<img class="minicart-4 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-4') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-4.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-5" data-class="minicart-5" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-5') : echo 'checked';
																											endif; ?> />
					<img class="minicart-5 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-5') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-5.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-6" data-class="minicart-6" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-6') : echo 'checked';
																											endif; ?> />
					<img class="minicart-6 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-6') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-6.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-7" data-class="minicart-7" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-7') : echo 'checked';
																											endif; ?> />
					<img class="minicart-7 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-7') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-7.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-8" data-class="minicart-8" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-8') : echo 'checked';
																											endif; ?> />
					<img class="minicart-8 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-8') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-8.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-icon" value="dojomc-icon-9" data-class="minicart-9" <?php if ($current_options['minicart-icon'] == 'dojomc-icon-9') : echo 'checked';
																											endif; ?> />
					<img class="minicart-9 <?php if ($current_options['minicart-icon'] == 'dojomc-icon-9') : echo 'cart-active';
											endif; ?>" src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'assets/graphics/dojomc-icon-9.png' ?>" alt="Mini Cart" width="50" height="50">
				</label>
			</fieldset>
		</div>
		<div class="block">
			<h3><?php _e('Minicart Position', 'dojo-minicart'); ?></h3>

			<fieldset>
				<legend class="screen-reader-text"><span><?php _e('Minicart Position', 'dojo-minicart') ?></span></legend>
				<label title='g:i a'>
					<input type="radio" name="minicart-position" value="dojomc-top-left" <?php if ($current_options['minicart-position'] == 'dojomc-top-left') : echo 'checked';
																							endif; ?> />
					<span>
						<?php _e('Top Left', 'dojo-minicart') ?>
					</span>
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-position" value="dojomc-top-right" <?php if ($current_options['minicart-position'] == 'dojomc-top-right') : echo 'checked';
																							endif; ?> />
					<span>
						<?php _e('Top Right', 'dojo-minicart') ?>
					</span>
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-position" value="dojomc-bottom-left" <?php if ($current_options['minicart-position'] == 'dojomc-bottom-left') : echo 'checked';
																							endif; ?> />
					<span>
						<?php _e('Bottom Left', 'dojo-minicart') ?>
					</span>
				</label>
				<label title='g:i a'>
					<input type="radio" name="minicart-position" value="dojomc-bottom-right" <?php if ($current_options['minicart-position'] == 'dojomc-bottom-right') : echo 'checked';
																								endif; ?> />
					<span>
						<?php _e('Bottom Right', 'dojo-minicart') ?>
					</span>
				</label>
			</fieldset>
		</div>
		<div class="block">
			<h3><?php _e('Offset', 'dojo-minicart'); ?></h3>
			<p><?php _e('Position from top, only applicable if Minicart position is either Top Left or Top Right.', 'dojo-minicart') ?></p>
			<input type="number" name="dojomc-offset" value="<?php echo $current_options['dojomc-offset']; ?>" /> px
		</div>
		<input class="button-primary dojomc-submit" type="submit" name="dojomc_option_submit" value="<?php esc_attr_e('Save Changes', 'dojomc-options-submit'); ?>" />

	</form>
</div>