<?php


/**
 * Include to add Bootstrap classes to Ninja Forms
 *
 *
 * @package dctheme
 */


function dctheme_ninja_forms_fixes($fields) {

    foreach ($fields as &$field) {

        $type = $field['type'] ?? '';

        switch($type) {

            case 'textarea':
                $field['element_class'] = 'form-control';
                break;

            case 'textbox':
            case 'firstname':
            case 'lastname':
            case 'address':
            case 'city':
            case 'zip':
            case 'date':
            case 'email':
            case 'phone':
                $field['element_class'] = 'form-control';
                break;

            case 'submit':
                $field['element_class'] = 'btn btn-primary';

            default:
        }
    }

    return $fields;
}


add_filter('ninja_forms_display_fields', 'dctheme_ninja_forms_fixes');