<?php


add_action('elementor/element/section/section_layout/after_section_start', 'dctheme_add_section_style_control');
add_action('elementor/element/column/layout/after_section_start', 'dctheme_add_column_style_control');
add_action('elementor/widgets/widgets_registered', 'dctheme_register_widgets');
add_action('elementor/element/heading/section_title/before_section_end', 'dctheme_elementor_widget_headline_fix');
add_action('elementor/element/button/section_button/before_section_end', 'dctheme_elementor_widget_button_fix');



function dctheme_elementor_widget_headline_fix(\Elementor\Widget_Heading $element) {

    $element->remove_control('align');
    $element->remove_control('align_tablet');
    $element->remove_control('align_mobile');

    $element->add_responsive_control(
        'align',
        [
            'label' => __( 'Alignment', 'elementor' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => __( 'Left', 'elementor' ),
                    'icon' => 'fa fa-align-left',
                ],
                'center' => [
                    'title' => __( 'Center', 'elementor' ),
                    'icon' => 'fa fa-align-center',
                ],
                'right' => [
                    'title' => __( 'Right', 'elementor' ),
                    'icon' => 'fa fa-align-right',
                ],
                'justify' => [
                    'title' => __( 'Justified', 'elementor' ),
                    'icon' => 'fa fa-align-justify',
                ],
            ],
            'default' => '',
            'prefix_class' => 'text-'
        ]
    );



    //var_dump($controls);
    //exit;
}



function dctheme_elementor_widget_button_fix(\Elementor\Widget_Button $element) {



    $element->remove_control('button_type');
    $element->remove_control('size');


    $element->add_control(
        'button_type',
        [
            'label' => __('Type', 'elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'outline-primary' => __('Primary', 'dctheme'),
                'outline-secondary' => __('Secondary', 'dctheme'),
                'outline-success' => __('Success', 'dctheme'),
                'outline-danger' => __('Danger', 'dctheme'),
                'outline-warning' => __('Warning', 'dctheme'),
                'outline-info' => __('Info', 'dctheme'),
                'outline-light' => __('Light', 'dctheme'),
                'outline-dark' => __('Dark', 'dctheme'),
            ],
            'default' => 'outline-primary',
        ],
        [
            'position' => [
                'type' => 'control',
                'at' => 'before',
                'of' => 'text'
            ],
        ]
    );

    $element->add_control(
        'size',
        [
            'label' => __('Size', 'elementor'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'sm' => __('Small', 'dctheme'),
                '' => __('Normal', 'dctheme'),
                'lg' => __('Large', 'dctheme')
            ],
            'default' => '',
        ],
        [
            'position' => [
                'type' => 'control',
                'at' => 'before',
                'of' => 'text'
            ],
        ]
    );
}


function dctheme_add_section_style_control(Elementor\Element_Section $element) {

    if ( 'section' === $element->get_name()) {
        $element->add_control(
            'dojo_style',
            [
                'type' => \Elementor\Controls_Manager::SELECT,
                'label' => __( 'Content Style', 'dctheme' ),
                'default' => 'default',
                'options' => [
                    'default' => __( 'Default', 'dctheme' ),
                    'light' => __( 'Light', 'dctheme' ),
                    'dark' => __( 'Dark', 'dctheme' ),
                    'color' => __( 'Color', 'dctheme' ),
                ],
                'prefix_class' => 'dojo-section-',
            ]
        );
    }
}



function dctheme_add_column_style_control(Elementor\Element_Column $element) {

    if ( 'column' === $element->get_name()) {
        $element->add_control(
            'dojo_style',
            [
                'type' => \Elementor\Controls_Manager::SELECT,
                'label' => __( 'Column Style', 'dctheme' ),
                'default' => '',
                'options' => [
                    '' => __( 'Default', 'dctheme' ),
                    'padded' => __( 'Padded', 'dctheme' ),
                ],
                'prefix_class' => 'dojo-column-',
            ]
        );
    }
}



function dctheme_register_widgets() {

    \Elementor\Plugin::instance()->widgets_manager->unregister_widget_type('button');

    require_once(dirname(__DIR__).'/elementor/menu-widget.php');
    require_once(dirname(__DIR__).'/elementor/post-widget.php');
    require_once(dirname(__DIR__).'/elementor/image-button-widget.php');
    require_once(dirname(__DIR__).'/elementor/button-widget.php');

    \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \DOJO_Menu_Widget() );
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \DOJO_Post_Widget() );
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \DOJO_Image_Button_Widget() );
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \DOJO_Button_Widget() );
}



function is_elementor(){
    global $post;
    return \Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID);
}