<?php

class DOJO_Menu_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'dojo_menu_widget';
    }

    public function get_title() {
        return __('Menu Item', 'dctheme');
    }

    public function get_icon() {
        return 'fa fa-cutlery';
    }

    public function get_categories() {
        return ['basic'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'dctheme' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Menu Item', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => __( 'Menu Item', 'dctheme' ),
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => __( 'Price', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'default' => __( '0.00', 'dctheme' ),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __( 'Description', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'input_type' => 'textarea',
                'default' => __( 'Menu description here.', 'dctheme' ),
            ]
        );

        $this->add_control(
            'features_vegetarian',
            [
                'label' => __('Vegetarian', 'dctheme'),
                'type' => \Elementor\Controls_Manager::SWITCHER,

            ]
        );

        $this->end_controls_section();



        $this->start_controls_section(
            'image_section',
            [
                'label' => __( 'Image', 'dctheme' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Menu Item Image', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        $this->add_inline_editing_attributes('title');
        $this->add_inline_editing_attributes('price');
        $this->add_inline_editing_attributes('description');

        $this->add_render_attribute('title', 'class', 'dojo-menu-item-title');
        $this->add_render_attribute('price', 'class', 'dojo-menu-item-price');
        $this->add_render_attribute('description', 'class', 'dojo-menu-item-description');

        $title = $settings['title'];
        $price = $settings['price'];
        $description = $settings['description'];
        $image = $settings['image'];


        echo '<div class="dojo-menu-item-widget">';

        if ($image['id']) {
            echo '<div class="dojo-menu-item-image">'.wp_get_attachment_image($image['id'], 'Medium Rect').'</div>';
        }
        echo '    <div class="dojo-menu-item-header">';
        echo '        <h5 '. $this->get_render_attribute_string('title') .'>'.$title.'</h5>';
        echo '        <span '. $this->get_render_attribute_string('price') .'>'.$price.'</span>';
        echo '    </div>';
        echo '    <div  '. $this->get_render_attribute_string('description') .'>'.nl2br($description).'</div>';
        echo '</div>';

    }


    protected function _content_template()
    {
        ?>
        <#

        view.addInlineEditingAttributes( 'description' );
        view.addInlineEditingAttributes( 'title' );
        view.addInlineEditingAttributes( 'price' );

        var image_url = '';

        if (settings.image.url) {

            var image = {
                id: settings.image.id,
                url: settings.image.url,
                size: settings.thumbnail_size,
                dimension: settings.thumbnail_custom_dimension,
                model: view.getEditModel()
            };

            image_url = elementor.imagesManager.getImageUrl(image);
        }
        #>
        <div class="dojo-menu-item-widget">
            <div class="dojo-menu-item-image">{{{ image_url }}}</div>
            <div class="dojo-menu-item-header">
                <h5 class="dojo-menu-item-title"><span {{{ view.getRenderAttributeString('title') }}}>{{{ settings.title }}}</span></h5>
                <span class="dojo-menu-item-price"><span {{{ view.getRenderAttributeString('price') }}}>{{{ settings.price }}}</span></span>
            </div>
            <div class="dojo-menu-item-description" {{{ view.getRenderAttributeString('description') }}}>{{{ settings.description }}}</div>
        </div>
        <?php
    }
}
