<?php

class DOJO_Image_Button_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'dojo_image_button_widget';
    }

    public function get_title() {
        return __('Image Button', 'dctheme');
    }

    public function get_icon() {
        return 'eicon-button';
    }

    public function get_categories() {
        return ['basic'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'dctheme' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => __( 'Link', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::URL,
                'input_type' => 'text',
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Button Image', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        $text = $settings['button_text'];
        $link = $settings['button_link'];
        $image = $settings['image'];

        echo '<div class="dojo-image-button-widget">';
        echo '<a href="'.$link['url'].'">';
        echo '<div class="dojo-image-button-image">'.wp_get_attachment_image($image['id'], 'Medium Rect').'</div>';
        echo '<div class="dojo-image-button-text">'.$text.'</div>';
        echo '</a>';
        echo '</div>';

    }

    //protected function _content_template() {}

}
