<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dojocreative
 */

?>

<?php if (is_singular()): ?>

    <header>
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
        <div class="post-date"><?php the_date() ?></div>
        <div class="header-image">
            <?php the_post_thumbnail('Large')  ?>
        </div>
    </header>
    <section>
        <?php the_content() ?>
    </section>
<?php else: ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <a href="<?= esc_url(get_permalink()) ?>"><?php the_post_thumbnail('Medium Rect') ?></a>
    <section>
        <?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
        <div class="post-date"><?php the_date() ?></div>
    </section>
</article><!-- #post-<?php the_ID(); ?> -->

<?php endif; ?>