<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package dctheme
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="page" class="site">
    <a class="sr-only sr-only-focusable" href="#content"><?php esc_html_e( 'Skip to content', 'dctheme' ); ?></a>

    <header id="masthead" class="site-header">
        <div class="container">
            <div class="row">
            <div class="site-branding col-sm-4">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-logo" rel="home">
                    <?php dctheme_logo(); ?>
                </a>
            </div><!-- .site-branding -->

            <nav class="nav col">
                <?php wp_nav_menu(['theme_location' => 'top']) ?>
            </nav>
            </div>
            <button id="menu-toggle" class="btn btn-link">
                <div class="hamburger hamburger--spring js-hamburger">
                    <div class="hamburger-box">
                        <div class="hamburger-inner"></div>
                    </div>
                </div>
            </button>
        </div>
    </header>

    <div id="content" class="site-content">
        <div class="<?= in_array('elementor-template-full-width', get_body_class()) ? '' : 'container' ?>">
            <div class="<?= in_array('elementor-template-full-width', get_body_class()) ? '' : 'row' ?>">
