<?php

class DOJO_Post_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'dojo_post_widget';
    }

    public function get_title() {
        return __('Post Listing', 'dctheme');
    }

    public function get_icon() {
        return 'fa fa-list';
    }

    public function get_categories() {
        return ['basic'];
    }

    protected function _register_controls() {

        $post_types = ['post' => 'Post'];

        $added_types = get_post_types([
            'public' => true,
            '_builtin' => false,
        ]);

        foreach ($added_types as $type) {
            $label = ucwords($type);
            $post_types[$type] = $label;
        }

        if (isset($post_types['elementor_library'])) {
            unset($post_types['elementor_library']);
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'dctheme' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'post_type',
            [
                'label' => __( 'Post Type', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $post_types,
                'default' => 'post',
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => 'Post List Style',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => ['grid' => 'Grid', 'list' => 'List'],
                'default' => 'grid'
            ]
        );


        $this->add_responsive_control(
            'grid_columns',
            [
                'label' => 'Columns',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                ],
                'default' => 3,
                'condition' => [
                    'style' => 'grid'
                ]
            ]
        );


        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );


        $this->add_control(
            'pager',
            [
                'label' => __( 'Show Pager', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => false,
            ]
        );



        $this->add_control(
            'per_page',
            [
                'label' => __( 'Posts Per Page', 'dctheme' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '12',
                'condition'		=> [
                    'pager' => 'yes',
                ],
            ]
        );


        $this->end_controls_section();

    }

    protected function render() {

        $settings   = $this->get_settings_for_display();

        $type       = $settings['post_type'];
        $style      = $settings['style'];
        $grid_col   = $settings['grid_columns'];
        $pager      = ($settings['pager'] === 'yes');
        $per_page   = $settings['per_page'];


        if ($style === 'grid') {
            $style.= ' dojo-post-grid-'.$grid_col;
            $style.= $settings['grid_columns_tablet'] ? ' dojo-post-grid-tablet-'.$settings['grid_columns_tablet'] : '';
            $style.= $settings['grid_columns_mobile'] ? ' dojo-post-grid-mobile-'.$settings['grid_columns_mobile'] : '';
        }

        $query_args = [
            'post_type' => $type
        ];

        if ($pager) {

            if ( get_query_var('paged') ) {
                $paged = get_query_var('paged');
            } elseif ( get_query_var('page') ) {
                $paged = get_query_var('page');
            } else {
                $paged = 1;
            }

            $query_args['posts_per_page'] = $per_page;
            $query_args['paged'] = $paged;
        }
        else {
            $query_args['nopaging'] = true;
        }

        $post_query = new WP_Query($query_args);


        if ($post_query->have_posts()) {

            echo '<div class="dojo-post-widget">';
            echo '<div class="content dojo-post-'.$style.'">';

            while ($post_query->have_posts()) {
                $post_query->the_post();
                get_template_part('template-parts/content', $type);
            }

            echo '</div>';

            if ($pager) {

                echo '<div class="pagination">';
                echo paginate_links( array(
                    'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
                    'total'        => $post_query->max_num_pages,
                    'current'      => max( 1, $paged ),
                    'format'       => '?page=%#%',
                    'show_all'     => false,
                    'type'         => 'plain',
                    'end_size'     => 2,
                    'mid_size'     => 1,
                    'prev_next'    => true,
                    'prev_text'    => sprintf( '<i></i> %1$s', __( 'Prev', 'text-domain' ) ),
                    'next_text'    => sprintf( '%1$s <i></i>', __( 'Next', 'text-domain' ) ),
                    'add_args'     => false,
                    'add_fragment' => '',
                ));
                echo '</div>';
            }

            echo '</div>';
        }

        wp_reset_postdata();
    }

    //protected function _content_template() {}

}
