var gulp = require("gulp"),
    scss = require("gulp-sass"),  
    autoprefixer = require("autoprefixer"),
    sourcemaps = require("gulp-sourcemaps"),
    postcss = require ("gulp-postcss"),
    notify = require("gulp-notify");

var theme_path = './html/content/themes/dctheme/';
var css_path = theme_path;
var scss_path = theme_path + 'scss/';
    
function style() {
    return gulp.src(scss_path + 'style.scss')
        .pipe(sourcemaps.init())
        .pipe(scss())
        .on("error", scss.logError)
        .pipe(postcss([ autoprefixer() ]))
        .pipe(sourcemaps.write())
        .pipe(gulp.dest(css_path))
        .on("error", notify.onError("Error: <%= error.message %>"))
        .pipe(notify("Compiled!"));
};

function watch(cb){
    gulp.watch(scss_path, style);
    cb();
}

gulp.task('default', gulp.parallel(style, watch));