<?php

namespace Dojo\Lionshead;

class Careers {
    
    public function __construct() {
        add_action( 'init', [$this, 'add_post_type']);
        add_action( 'acf/include_fields', [$this, 'add_fields']);
    }


    public function add_post_type()
    {
        $labels = [
            'name' => 'Careers',
            'singular_name' => 'Career',
            'menu_name' => 'Careers',
            'all_items' => 'All Careers',
            'edit_item' => 'Edit Career',
            'view_item' => 'View Career',
            'view_items' => 'View Careers',
            'add_new_item' => 'Add New Career',
            'add_new' => 'Add New Career',
            'new_item' => 'New Career',
            'parent_item_colon' => 'Parent Career:',
            'search_items' => 'Search Careers',
            'not_found' => 'No careers found',
            'not_found_in_trash' => 'No careers found in Trash',
            'archives' => 'Career Archives',
            'attributes' => 'Career Attributes',
            'insert_into_item' => 'Insert into career',
            'uploaded_to_this_item' => 'Uploaded to this career',
            'filter_items_list' => 'Filter careers list',
            'filter_by_date' => 'Filter careers by date',
            'items_list_navigation' => 'Careers list navigation',
            'items_list' => 'Careers list',
            'item_published' => 'Career published.',
            'item_published_privately' => 'Career published privately.',
            'item_reverted_to_draft' => 'Career reverted to draft.',
            'item_scheduled' => 'Career scheduled.',
            'item_updated' => 'Career updated.',
            'item_link' => 'Career Link',
            'item_link_description' => 'A link to a career.',
        ];

        register_post_type( 'career', array(
            'labels' => $labels,
            'public' => true,
            'show_in_rest' => true,
            'menu_icon' => 'dashicons-groups',
            'supports' => ['title', 'custom-fields'],
            'delete_with_user' => false,
        ) );

    }

    public function add_fields()
    {
        acf_add_local_field_group( array(
            'key' => 'group_659f0735e8971',
            'title' => 'Career fields',
            'fields' => array(
                array(
                    'key' => 'field_659f0736d859f',
                    'label' => 'Job Location',
                    'name' => 'job_location',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                ),
                array(
                    'key' => 'field_659f0771d85a1',
                    'label' => 'Job Description',
                    'name' => 'job_description',
                    'aria-label' => '',
                    'type' => 'wysiwyg',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'tabs' => 'all',
                    'toolbar' => 'basic',
                    'media_upload' => 0,
                    'delay' => 0,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'career',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ));
    }
    
    
}