<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package lionshead-theme
 */

?>

<?php if (is_singular()): ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('full'); ?>>
        <?php if (!is_elementor()): ?>
            <header class="entry-header">
                <div class="date"><?= get_the_date('m.d.Y') ?></div>
                <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
            </header>
        <?php endif; ?>

        <?php lionshead_theme_post_thumbnail('blog-full'); ?>

        <div class="entry-content">
            <?php the_content(); ?>
        </div>
    </article>

<?php else: ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('teaser'); ?>>
        <div class="post-image">
            <?php lionshead_theme_post_thumbnail('blog-thumb'); ?>
        </div>
        <div class="post-summary">
            <div class="date"><?= get_the_date('m.d.Y') ?></div>
            <?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>
            <?php the_excerpt(); ?>
            <div class="readmore"><a href="<?= get_permalink() ?>">Read More</a></div>
        </div>
    </article>

<?php endif; ?>
