<?php


namespace Dojo\Lionshead;
class ElementorCleanup {

    public function __construct() {

        add_action('elementor/widgets/register', [$this, 'unregister_widgets']);

        add_action('elementor/editor/wp_head', function () {
            echo '
            <style>
              #elementor-panel-category-pro-elements,
              #elementor-panel-category-theme-elements,
              #elementor-panel-category-theme-elements-single,
              #elementor-panel-category-woocommerce-elements {
                display: none;
              }
            </style>';
        }, 100);
    }

    /**
     * Unregister multiple unused widgets.
     *
     * @param \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager.
     * @return void
     */
    function unregister_widgets(\Elementor\Widgets_Manager $widgets_manager) {

        $widgets_to_unregister = [
            'wp-widget-pages',
            'wp-widget-archives',
            'wp-widget-media_audio',
            'wp-widget-media_image',
            'wp-widget-media_gallery',
            'wp-widget-media_video',
            'wp-widget-meta',
            'wp-widget-search',
            'wp-widget-text',
            'wp-widget-categories',
            'wp-widget-recent-posts',
            'wp-widget-recent-comments',
            'wp-widget-rss',
            'wp-widget-tag_cloud',
            'wp-widget-nav_menu',
            'wp-widget-custom_html',
            'wp-widget-polylang',
            'wp-widget-calendar',
            'wp-widget-elementor-library',
            'wp-widget-block'
        ];

        foreach ( $widgets_to_unregister as $widget ) {
            $widgets_manager->unregister( $widget );
        }

    }


}