<?php
/**
 * lionshead-theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package lionshead-theme
 */

const LIONSHEAD_VER = '1.0';
require_once 'vendor/autoload.php';






/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';


/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';




$theme = new \Dojo\Lionshead\ThemeSetup([
    new \Dojo\Lionshead\OptionsPage(),
    new \Dojo\Lionshead\ElementorCleanup(),
    new \Dojo\Lionshead\ElementorContainerStyle(),
    new \Dojo\Lionshead\Shortcodes(),
    new \Dojo\Lionshead\MenuMobileClass(),
    new \Dojo\Lionshead\ElementorWidgets()
]);


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function lionshead_theme_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'lionshead_theme_content_width', 640 );
}
add_action( 'after_setup_theme', 'lionshead_theme_content_width', 0 );


