<?php

namespace Dojo\Lionshead;

class OptionsPage {

    public function __construct()
    {
        if (function_exists( 'acf_add_local_field_group')) {
            $this->options_page();
            $this->field_group();
        }
    }

    public function options_page()
    {
        acf_add_options_page([
            'page_title' => 'Lionshead Settings',
            'menu_slug' => 'lionshead-settings',
            'position' => '',
            'redirect' => false,
        ]);
    }

    public function field_group()
    {
        acf_add_local_field_group([
            'key' => 'group_659712e47efba',
            'title' => 'Contact Information',
            'fields' => array(
                array(
                    'key' => 'field_659712e9e93b7',
                    'label' => 'Street',
                    'name' => 'location_street',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65971331e93b8',
                    'label' => 'City',
                    'name' => 'location_city',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6597133be93b9',
                    'label' => 'State',
                    'name' => 'location_state',
                    'aria-label' => '',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'AL' => 'AL',
                        'AK' => 'AK',
                        'AZ' => 'AZ',
                        'AR' => 'AR',
                        'CA' => 'CA',
                        'CO' => 'CO',
                        'CT' => 'CT',
                        'DE' => 'DE',
                        'FL' => 'FL',
                        'GA' => 'GA',
                        'HI' => 'HI',
                        'ID' => 'ID',
                        'IL' => 'IL',
                        'IN' => 'IN',
                        'IA' => 'IA',
                        'KS' => 'KS',
                        'KY' => 'KY',
                        'LA' => 'LA',
                        'ME' => 'ME',
                        'MD' => 'MD',
                        'MA' => 'MA',
                        'MI' => 'MI',
                        'MN' => 'MN',
                        'MS' => 'MS',
                        'MO' => 'MO',
                        'MT' => 'MT',
                        'NE' => 'NE',
                        'NV' => 'NV',
                        'NH' => 'NH',
                        'NJ' => 'NJ',
                        'NM' => 'NM',
                        'NY' => 'NY',
                        'NC' => 'NC',
                        'ND' => 'ND',
                        'OH' => 'OH',
                        'OK' => 'OK',
                        'OR' => 'OR',
                        'PA' => 'PA',
                        'RI' => 'RI',
                        'SC' => 'SC',
                        'SD' => 'SD',
                        'TN' => 'TN',
                        'TX' => 'TX',
                        'UT' => 'UT',
                        'VT' => 'VT',
                        'VA' => 'VA',
                        'WA' => 'WA',
                        'WV' => 'WV',
                        'WI' => 'WI',
                        'WY' => 'WY',
                    ),
                    'default_value' => false,
                    'return_format' => 'value',
                    'multiple' => 0,
                    'allow_null' => 0,
                    'ui' => 0,
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_659713b9e93ba',
                    'label' => 'Zip',
                    'name' => 'location_zip',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'min' => 10000,
                    'max' => 99999,
                    'placeholder' => '',
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_659713e6e93bb',
                    'label' => 'Phone',
                    'name' => 'location_phone',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_659713ffe93bc',
                    'label' => 'Fax',
                    'name' => 'location_fax',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65971408e93bd',
                    'label' => 'Email',
                    'name' => 'location_email',
                    'aria-label' => '',
                    'type' => 'email',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'lionshead-settings',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'left',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);


        acf_add_local_field_group( [
            'key' => 'group_659f0735e8971',
            'title' => 'Career fields',
            'fields' => array(
                array(
                    'key' => 'field_659f0736d859f',
                    'label' => 'Job Location',
                    'name' => 'job_location',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_659f0771d85a1',
                    'label' => 'Job Description',
                    'name' => 'job_description',
                    'aria-label' => '',
                    'type' => 'wysiwyg',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'tabs' => 'all',
                    'toolbar' => 'basic',
                    'media_upload' => 0,
                    'delay' => 0,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'career',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);

        acf_add_local_field_group( [
            'key' => 'group_65a1783b0a90f',
            'title' => 'Footer Settings',
            'fields' => [
                [
                    'key' => 'field_65a17840ba696',
                    'label' => 'Contact Page',
                    'name' => 'contact_page',
                    'aria-label' => '',
                    'type' => 'link',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => [
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ],
                    'return_format' => 'array',
                ],
                [
                    'key' => 'field_65a17947ba697',
                    'label' => 'Footer Text',
                    'name' => 'footer_text',
                    'aria-label' => '',
                    'type' => 'wysiwyg',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => [
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ],
                    'default_value' => '',
                    'tabs' => 'all',
                    'toolbar' => 'full',
                    'media_upload' => 1,
                    'delay' => 0,
                ],
                [
                    'key' => 'field_65a17954ba698',
                    'label' => 'Social Links',
                    'name' => 'social_links',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => [
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ],
                    'layout' => 'table',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => [
                        [
                            'key' => 'field_65a179dcba699',
                            'label' => 'Social Channel',
                            'name' => 'social_channel',
                            'aria-label' => '',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => [
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ],
                            'choices' => [
                                'Facebook' => 'Facebook',
                                'YouTube' => 'YouTube',
                                'Linked-In' => 'Linked-In',
                                'X' => 'X',
                                'Email' => 'Email',
                            ],
                            'default_value' => false,
                            'return_format' => 'value',
                            'multiple' => 0,
                            'allow_null' => 0,
                            'ui' => 0,
                            'ajax' => 0,
                            'placeholder' => '',
                            'parent_repeater' => 'field_65a17954ba698',
                        ],
                        [
                            'key' => 'field_65a17a4eba69a',
                            'label' => 'Link',
                            'name' => 'link',
                            'aria-label' => '',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => [
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ],
                            'default_value' => '',
                            'placeholder' => '',
                            'parent_repeater' => 'field_65a17954ba698',
                        ],
                    ],
                ],
            ],
            'location' => [
                [
                    [
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'lionshead-settings',
                    ],
                ],
            ],
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);

        acf_add_local_field_group( [
            'key' => 'group_65ba845a8075d',
            'title' => 'Header Settings',
            'fields' => [
                [
                    'key' => 'field_65ba845b61c83',
                    'label' => 'CTA Button',
                    'name' => 'cta_button',
                    'aria-label' => '',
                    'type' => 'link',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => [
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ],
                    'return_format' => 'array',
                ],
            ],
            'location' => [
                [
                    [
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'lionshead-settings',
                    ],
                ],
            ],
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);

        acf_add_local_field_group( [
            'key' => 'group_65a182ebe4d32',
            'title' => 'Career Page Settings',
            'fields' => [
                [
                    'key' => 'field_65a182f1746bf',
                    'label' => 'Default Image',
                    'name' => 'career_default_image',
                    'aria-label' => '',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => [
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ],
                    'return_format' => 'url',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                    'preview_size' => 'medium',
                ],
                [
                    'key' => 'field_65a18314746c0',
                    'label' => 'Form Shortcode',
                    'name' => 'career_form_shortcode',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => [
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ],
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ],
            ],
            'location' => [
                [
                    [
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'lionshead-settings',
                    ],
                ],
            ],
            'menu_order' => 50,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);

    }

}