<?php

$cta_button = '';
$cta_button_info = get_field('cta_button', 'option');

if ($cta_button_info) {

    $cta_button = '<li class="contact">';
    $cta_button.= sprintf('<a href="%s" target="%s">%s</a>', $cta_button_info['url'], $cta_button_info['target'], $cta_button_info['title']);
    $cta_button.= '</li>';
}


?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'lionshead-theme' ); ?></a>

	<header id="masthead" class="site-header">
		<div class="site-branding"><?php the_custom_logo(); ?></div>
		<nav id="site-navigation" class="main-navigation">
			<button id="menu-toggle" class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><span></span><?php esc_html_e( 'Menu', 'lionshead-theme' ); ?></button>
            <div id="menu" class="menu-wrapper">
                <?php wp_nav_menu(['theme_location' => 'main-menu']); ?>
                <div class="secondary-menu">
                    <ul>
                        <li><a href="tel:+1<?= get_field('location_phone', 'option') ?>"><?= get_field('location_phone', 'option') ?></a></li>
                        <?= $cta_button ?>
                    </ul>
                </div>
            </div>
		</nav>
	</header>
     <?php

     if (function_exists('yoast_breadcrumb') && !is_front_page()) {
        yoast_breadcrumb( '<div id="breadcrumbs"><div class="inner">','</div></div>' );
     }

     ?>