<?php

namespace Dojo\Lionshead;
class MenuMobileClass {

    public function __construct() {

        add_action('wp_nav_menu_item_custom_fields', [$this, 'custom_fields'], 10, 2);
        add_action('wp_update_nav_menu_item', [$this, 'update_nav'], 10, 2);
        add_filter('nav_menu_css_class', [$this, 'nav_css'], 10, 2);
    }

    public function custom_fields($item_id, $item)
    {
        $show_on_mobile = get_post_meta($item_id, '_show-on-mobile', true);
        $id = 'dojo-menu-mobile-' . $item_id;
        $checked = checked($show_on_mobile, true);
        $label = __('Show only on mobile', 'dctheme');

        echo '<p class="dojo-show-as-button description description-wide">';
        echo '   <label for="'.$id.'">';
        echo '   <input type="checkbox" id="'.$id.'" name="dojo-menu-mobile['.$item_id.']" '.$checked.' />';
        echo     $label;
        echo '   </label>';
        echo '</p>';
    }

    public function update_nav($menu_id, $menu_item_db_id) {
        $value = $_POST['dojo-menu-mobile'][$menu_item_db_id] ?? '';
        $button_value = $value === 'on';
        update_post_meta($menu_item_db_id, '_show-on-mobile', $button_value);
    }

    public function nav_css($classes, $menu_item)
    {
        $show_on_mobile = get_post_meta($menu_item->ID, '_show-on-mobile', true);

        if ($show_on_mobile) {
            $classes[] = 'mobile-only';
        }
        return $classes;
    }
}