<?php

namespace Dojo\Lionshead;

use \Elementor\Includes\Elements\Container;

class ElementorContainerStyle {

    public function __construct() {
        add_action('elementor/element/container/section_layout_container/after_section_start', [$this, 'add_container_style_control']);
    }


    /**
     * @param Container $element
     * @return void
     */
    public function add_container_style_control(\Elementor\Includes\Elements\Container $element): void
    {

        if ( 'container' === $element->get_name()) {

            $element->add_control(
                'dojo_style',
                [
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'label' => __( 'Content Style', 'lionshead-theme' ),
                    'default' => '',
                    'options' => [
                        '' => __('None', 'lionshead-theme'),
                        'default' => __( 'Default', 'lionshead-theme' ),
                        'header' => __( 'Header', 'lionshead-theme' ),
                        'blue' => __( 'Blue Background', 'lionshead-theme' ),
                        'gray' => __( 'Gray', 'lionshead-theme' ),
                    ],
                    'prefix_class' => 'p-con-',
                ]
            );
        }
    }
}