<?php

namespace Dojo\Lionshead;


class ThemeSetup {

    public function __construct(array $objs) {

        add_action('wp_enqueue_scripts', [$this, 'add_scripts']);
        add_action('after_setup_theme', [$this, 'theme_support']);
        add_action('after_setup_theme', [$this, 'register_menu']);
        add_action('widgets_init', [$this, 'register_sidebar']);
    }


    public function init() {
        $script_action = \is_elementor() ? 'elementor/frontend/after_enqueue_styles' : 'wp_enqueue_scripts';
        add_action($script_action, [$this, 'add_scripts']);
    }

    /**
     * Add Theme Scripts and Styles
     * @return void
     */
    public function add_scripts(): void
    {
        wp_enqueue_style('lionshead-theme-style', get_stylesheet_uri(), ['elementor-frontend'], LIONSHEAD_VER );
        wp_enqueue_script('lionshead-theme-navigation', get_template_directory_uri() . '/js/navigation.js', [], LIONSHEAD_VER, true);

        if (is_singular() && comments_open() && get_option( 'thread_comments' )) {
            wp_enqueue_script( 'comment-reply' );
        }
    }


    /**
     * Adds theme support for optional Wordpress Features
     * @return void
     */
    public function theme_support(): void
    {
        add_theme_support('wp-block-styles'); // Add Block Style Support For Gutenberg
        add_theme_support('custom-logo'); // Add support for core custom logo.
        add_theme_support('title-tag'); // Let Wordpress Manage Document Title
        add_theme_support('customize-selective-refresh-widgets'); // Add theme support for selective refresh for widgets.
        add_theme_support('post-thumbnails'); // Enable support for Post Thumbnails on posts and pages.
        /*
         * Should be automatically loaded.

        // add_theme_support( 'automatic-feed-links' ); // Add default posts and comments RSS feed links to head.

        // add_theme_support('html5', $html5_elements); // Switch default core markup for elements to output valid HTML5.
        // $html5_elements = [
        //            'search-form',
        //            'comment-form',
        //            'comment-list',
        //            'gallery',
        //            'caption',
        //            'style',
        //            'script'
        //        ];*/
    }

    /**
     * Registers the main menu of the Lionshead Theme
     * @return void
     */
    public function register_menu(): void
    {
        register_nav_menus([
            'main-menu' => 'Main Menu'
        ]);
    }


    /**
     * Registers Sidebar for Lionshead Blog
     * @return void
     */
    public function register_sidebar(): void
    {
        register_sidebar(
            array(
                'name'          => esc_html__( 'Sidebar', 'lionshead-theme' ),
                'id'            => 'blog-sidebar',
                'description'   => esc_html__( 'Add widgets here.', 'lionshead-theme' ),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget'  => '</section>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__( 'Footer', 'lionshead-theme' ),
                'id'            => 'footer',
                'description'   => esc_html__( 'Add widgets here.', 'lionshead-theme' ),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget'  => '</section>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
            )
        );
    }
}


