Lionshead Theme
===
Lionshead base theme created by DOJO Creative to use on all lionshead projects.  Assumes Elementor page builder will be installed.


### Requirements

`lionshead-theme` requires the following dependencies:

- [Node.js](https://nodejs.org/)
- [Composer](https://getcomposer.org/)
- [Elementor](https://elementor.com/)


### Quick Start

This theme is meant to be a parent theme for all Lionshead websites.

1. Download theme.
2. Create a child theme manually or using the available CLI commands.

```sh
wp scaffold child-theme lionshead-child --parent_theme=lionshead-theme
```

### Setup

To start using all the tools that come with `lionshead-theme`  you need to install the necessary Node.js and Composer dependencies :

```sh
$ composer install
$ npm install
```

### Available CLI commands for parent theme development

`lionshead-theme` CLI commands for theme development:

- `npm run compile:css` : compiles SASS files to css.
- `npm run compile:rtl` : generates an RTL stylesheet.
- `npm run watch` : watches all SASS files and recompiles them to css when they change.
- `npm run lint:scss` : checks all SASS files against [CSS Coding Standards](https://developer.wordpress.org/coding-standards/wordpress-coding-standards/css/).
- `npm run lint:js` : checks all JavaScript files against [JavaScript Coding Standards](https://developer.wordpress.org/coding-standards/wordpress-coding-standards/javascript/).