<?php

namespace Dojo\Lionshead\Widgets;


use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;

class CTAWidget extends \Elementor\Widget_Base {
    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'cta';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'CTA Widget', 'lionshead-theme' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-testimonial';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @since 2.1.0
     * @access public
     *
     * @return array Widget keywords.
     */
    public function get_keywords() {
        return ['blockquote' ];
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the text editor widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * @since 2.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'basic' ];
    }


    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 3.1.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_cta',
            [
                'label' => esc_html__( 'CTA', 'lionshead-theme' ),
            ]
        );

        $this->add_control(
            'headline',
            [
                'label' => esc_html__( 'Headline', 'lionshead-theme' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'rows' => '10',
                'default' => esc_html__( 'Lorem ipsum dolor sit amet', 'lionshead-theme' ),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( 'Content', 'lionshead-theme' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'rows' => '10',
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'lionshead-theme' ),
            ]
        );

        $this->add_control(
            'link_text',
            [
                'label' => esc_html__( 'Link Text', 'lionshead-theme' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => 'Click Here',
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'lionshead-theme' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();


        // Headline.
        $this->start_controls_section(
            'section_style_cta_headline',
            [
                'label' => esc_html__( 'Headline', 'lionshead-theme' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'headline_color',
            [
                'label' => esc_html__( 'Text Color', 'lionshead-theme' ),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_TEXT,
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-cta-headline' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'headline_typography',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ],
                'selector' => '{{WRAPPER}} .elementor-cta-headline',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'headline_shadow',
                'selector' => '{{WRAPPER}} .elementor-cta-headline',
            ]
        );

        $this->end_controls_section();



        // Content.
        $this->start_controls_section(
            'section_style_cta_content',
            [
                'label' => esc_html__( 'Content', 'lionshead-theme' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Text Color', 'lionshead-theme' ),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_TEXT,
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-cta-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ],
                'selector' => '{{WRAPPER}} .elementor-cta-content',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'content_shadow',
                'selector' => '{{WRAPPER}} .elementor-cta-content',
            ]
        );

        $this->end_controls_section();



        // Name.
        $this->start_controls_section(
            'section_style_link',
            [
                'label' => esc_html__( 'Link', 'lionshead-theme' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'link_text_color',
            [
                'label' => esc_html__( 'Text Color', 'lionshead-theme' ),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_PRIMARY,
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-cta-meta' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-cta-inner' => 'border-left-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'link_typography',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector' => '{{WRAPPER}} .elementor-cta-link',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'link_shadow',
                'selector' => '{{WRAPPER}} .elementor-cta-link',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $this->add_render_attribute( 'wrapper', 'class', 'elementor-cta-wrapper' );
        $this->add_render_attribute( 'meta', 'class', 'elementor-cta-meta' );

        $has_headline = ! ! $settings['headline'];
        $has_content = ! ! $settings['content'];
        $has_link = ! ! $settings['link'];

        if (!$has_content) {
            return;
        }

        if ( ! empty( $settings['link']['url'] ) ) {
            $this->add_link_attributes( 'link', $settings['link'] );
        }
        ?>
        <div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
            <div class="elementor-cta-inner">
            <?php
            if ( $has_headline ) :
                $this->add_render_attribute( 'headline', 'class', 'elementor-cta-headline' );
                $this->add_inline_editing_attributes( 'headline' );
                ?>
                <h4 <?php $this->print_render_attribute_string( 'headline' ); ?>><?php $this->print_unescaped_setting( 'headline' ); ?></h4>
            <?php endif; ?>
            <?php
            if ( $has_content ) :
                $this->add_render_attribute( 'content', 'class', 'elementor-cta-content' );
                $this->add_inline_editing_attributes( 'content' );
                ?>
                <div <?php $this->print_render_attribute_string( 'content' ); ?>><?php $this->print_unescaped_setting( 'content' ); ?></div>
            <?php endif; ?>

            <?php if ( $has_link ) : ?>
                <div <?php $this->print_render_attribute_string( 'meta' ); ?>>
                    <?php if (!empty( $settings['link']['url'])): ?>
                        <a <?php $this->print_render_attribute_string( 'link' ); ?>><?php $this->print_unescaped_setting( 'link_text' ); ?></a>
                    <?php else: ?>
                        <div <?php $this->print_render_attribute_string( 'link' ); ?>><?php $this->print_unescaped_setting( 'link_text' ); ?></div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            </div>
        </div>
        <?php
    }



    /**
     * Render testimonial widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 2.9.0
     * @access protected
     */

    protected function content_template() {
        ?>
        <div class="elementor-cta-wrapper">
            <div class="elementor-cta-inner">
            <# if ( '' !== settings.headline ) {

                view.addRenderAttribute( 'headline', {
                    'data-binding-type': 'headline',
                    'data-binding-setting': 'headline',
                });

                view.addRenderAttribute( 'headline', 'class', 'elementor-cta-headline' );
                view.addInlineEditingAttributes( 'headline' );
                #>
                <h4 {{{ view.getRenderAttributeString( 'headline' ) }}}>{{{ settings.headline }}}</h4>
            <# } #>

            <# if ( '' !== settings.content ) {

                view.addRenderAttribute( 'content', {
                    'data-binding-type': 'content',
                    'data-binding-setting': 'content',
                });

                view.addRenderAttribute( 'content', 'class', 'elementor-cta-content' );
                view.addInlineEditingAttributes( 'content' );
                #>
                <div {{{ view.getRenderAttributeString( 'content' ) }}}>{{{ settings.content }}}</div>
            <# } #>
            <div class="elementor-cta-meta">
                <# if ( settings.link.url ) { #>
                    <a href="{{ settings.link.url }}" {{{ view.getRenderAttributeString( 'link' ) }}}>{{{ settings.link_text }}}</a>
                <# } else { #>
                    <div {{{ view.getRenderAttributeString( 'link' ) }}}>{{{ settings.link_text }}}</div>
                <# } #>
            </div>
            </div>
        </div>
        <?php
    }

}