<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package lionshead-theme
 */

get_header();
$p = get_queried_object();

?>
	<main id="primary" class="blog-posts">

        <div class="blog-posts-header elementor-element p-con-header e-con-full e-flex e-con e-parent">
            <div class="elementor-element e-con-full e-flex e-con e-child">
                <h1><?= $p->post_title ?></h1>
            </div>
        </div>

        <div class="post-listing">

            <div class="post-articles">
                <?= $p->post_content ?>
		        <?php if (have_posts()): ?>

                    <header>
                        <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                    </header>

                    <?php
                        while (have_posts()):
                            the_post();
                            get_template_part( 'template-parts/content', get_post_type() );
                        endwhile;
                        the_posts_navigation();
                    ?>

                <?php else: ?>
                    <?php get_template_part( 'template-parts/content', 'none' ); ?>
		        <?php endif; ?>
            </div>

            <div class="post-sidebar">
                <?php dynamic_sidebar('blog-sidebar'); ?>
            </div>
        </div>
	</main><!-- #main -->
    <style>

        .blog-posts-header {
            background-image:url('<?= get_the_post_thumbnail_url($p) ?>');
        }

    </style>

<?php
get_footer();
