<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package lionshead-theme
 */

use Elementor\Plugin;


/**
 * Displays an optional post thumbnail.
 *
 * Wraps the post thumbnail in an anchor element on index views, or a div
 * element when on single views.
 */
function lionshead_theme_post_thumbnail()
{

    if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
        return;
    }

    if ( is_singular() ) {

        echo '<div class="post-thumbnail">';
        the_post_thumbnail();
        echo '</div>';
    }
    else {

        echo '<a class="post-thumbnail" href="'. get_permalink() . '" aria-hidden="true" tabindex="-1">';
        the_post_thumbnail('post-thumbnail', [ 'alt' => the_title_attribute(['echo' => false])]);
        echo '</a>';
    }
}

/**
 * Determines if any given post was created using Elementor
 * Used in template and when loading scripts.
 */
function is_elementor(){

    global $post;

    if (!$post) {
        return false;
    }

    $document = Plugin::$instance->documents->get($post->ID);

    if (!$document) {
        return false;
    }

    return $document->is_built_with_elementor();
}