<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package lionshead-theme
 */

?>
	<footer id="site-footer">
        <div class="main-footer inner">
            <div class="contact">
                <?php the_custom_logo() ?>
                <div class="contact-info">
                    <div class="adr">
                        <div class="street-address"><?= get_field('location_street', 'option') ?></div>
                        <span class="locality"><?= get_field('location_city', 'option') ?></span>,
                        <span class="region"><?= get_field('location_state', 'option') ?></span>
                        <span class="postal-code"><?= get_field('location_zip', 'option') ?></span>
                    </div>
                    <div class="phone">Phone: <a href="tel:+1<?= get_field('location_phone', 'option') ?>"><?= get_field('location_phone', 'option') ?></a></div>
                    <div class="fax">Fax: <a href="tel:+1<?= get_field('location_fax', 'option') ?>"><?= get_field('location_fax', 'option') ?></a></div>
                    <div class="email"><a href="mailto:<?= get_field('location_email', 'option') ?>"><?= get_field('location_email', 'option') ?></a></div>
                </div>
            </div>
            <div class="info">
                <div class="logos">
                    <a href=""><img src="https://placehold.co/200" alt="Lionshead Precision Metals"></a>
                    <a href=""><img src="https://placehold.co/200" alt="Lionshead Precision Metals"></a>
                    <a href=""><img src="https://placehold.co/200" alt="Lionshead Precision Metals"></a>
                    <a href=""><img src="https://placehold.co/200" alt="Lionshead Precision Metals"></a>
                    <a href=""><img src="https://placehold.co/200" alt="Lionshead Precision Metals"></a>
                </div>
                <div>
                    <?php dynamic_sidebar('footer') ?>
                </div>
            </div>
        </div>
	</footer>
    <section id="legal" class="elementor-element">
        <div class="legal-footer inner">
            <div><?= do_shortcode('[copyright]') ?></div>
            <div><?= do_shortcode('[dojo-d]') ?></div>
        </div>
    </section>
</div>

<?php wp_footer(); ?>

</body>
</html>
