<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package lionshead-theme
 */
$contact_page = get_field('contact_page', 'option');
$form_shortcode = get_field('career_form_shortcode', 'option');
$default_image = get_field('career_default_image', 'option');
$thumbnail_image = get_the_post_thumbnail_url();
$header_image = $thumbnail_image ?: $default_image;
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('career-page'); ?>>
    <div class="elementor-element career-header p-con-header e-con-full e-flex e-con e-parent">
        <div class="elementor-element e-con-full e-flex e-con e-child">

            <div class="elementor-element elementor-element-1f0cece5 elementor-widget elementor-widget-heading">
                <div class="elementor-widget-container">
                    <h1 class="elementor-heading-title elementor-size-default">CAREERS</h1>
                </div>
            </div>

            <?php if ($contact_page): ?>
            <div class="elementor-element elementor-widget elementor-widget-button">
                <a class="elementor-button elementor-button-link elementor-size-sm" href="<?= $contact_page['url'] ?>">
                    <span class="elementor-button-content-wrapper">
                        <span class="elementor-button-text"><?= $contact_page['title'] ?></span>
                    </span>
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php if ($header_image): ?>
    <style>
        .career-header {
            background-image:url('<?= $header_image ?>');
            background-position: center center;
            background-size: cover;
        }
    </style>
    <?php endif; ?>

    <div class="elementor-element career-info p-con-default e-flex e-con-boxed e-con e-parent" data-id="d8b8a00" data-element_type="container" data-settings="{&quot;container_type&quot;:&quot;flex&quot;,&quot;content_width&quot;:&quot;boxed&quot;}" data-core-v316-plus="true">
        <div class="e-con-inner">
            <div class="elementor-element elementor-element-7c55774 e-con-full e-flex e-con e-child" data-id="7c55774" data-element_type="container" data-settings="{&quot;content_width&quot;:&quot;full&quot;,&quot;container_type&quot;:&quot;flex&quot;}">
                <?php the_title('<h2>', '</h2>') ?>
                <?php the_field('job_description') ?>


                <?php if ($contact_page): ?>

                    <div class="elementor-element elementor-widget elementor-widget-button">
                        <h5>Questions?</h5>
                        <a class="elementor-button elementor-button-link elementor-size-sm" href="<?= $contact_page['url'] ?>">
                            <span class="elementor-button-content-wrapper">
                                <span class="elementor-button-text"><?= $contact_page['title'] ?></span>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>


            </div>
            <div class="elementor-element e-con-full e-flex e-con e-child">
                <?php if ($form_shortcode): ?>
                    <?= do_shortcode($form_shortcode) ?>
                <?php endif; ?>
            </div>
        </div>
    </div>


</article>
