<?php

namespace Dojo\Lionshead;

class OptionsPage {

    public function __construct()
    {
        if (function_exists( 'acf_add_local_field_group')) {
            $this->options_page();
            $this->field_group();
        }
    }

    public function options_page()
    {
        acf_add_options_page([
            'page_title' => 'Lionshead Settings',
            'menu_slug' => 'lionshead-settings',
            'position' => '',
            'redirect' => false,
        ]);
    }

    public function field_group()
    {
        acf_add_local_field_group([
            'key' => 'group_659712e47efba',
            'title' => 'Contact Information',
            'fields' => array(
                array(
                    'key' => 'field_659712e9e93b7',
                    'label' => 'Street',
                    'name' => 'location_street',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65971331e93b8',
                    'label' => 'City',
                    'name' => 'location_city',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6597133be93b9',
                    'label' => 'State',
                    'name' => 'location_state',
                    'aria-label' => '',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'AL' => 'AL',
                        'AK' => 'AK',
                        'AZ' => 'AZ',
                        'AR' => 'AR',
                        'CA' => 'CA',
                        'CO' => 'CO',
                        'CT' => 'CT',
                        'DE' => 'DE',
                        'FL' => 'FL',
                        'GA' => 'GA',
                        'HI' => 'HI',
                        'ID' => 'ID',
                        'IL' => 'IL',
                        'IN' => 'IN',
                        'IA' => 'IA',
                        'KS' => 'KS',
                        'KY' => 'KY',
                        'LA' => 'LA',
                        'ME' => 'ME',
                        'MD' => 'MD',
                        'MA' => 'MA',
                        'MI' => 'MI',
                        'MN' => 'MN',
                        'MS' => 'MS',
                        'MO' => 'MO',
                        'MT' => 'MT',
                        'NE' => 'NE',
                        'NV' => 'NV',
                        'NH' => 'NH',
                        'NJ' => 'NJ',
                        'NM' => 'NM',
                        'NY' => 'NY',
                        'NC' => 'NC',
                        'ND' => 'ND',
                        'OH' => 'OH',
                        'OK' => 'OK',
                        'OR' => 'OR',
                        'PA' => 'PA',
                        'RI' => 'RI',
                        'SC' => 'SC',
                        'SD' => 'SD',
                        'TN' => 'TN',
                        'TX' => 'TX',
                        'UT' => 'UT',
                        'VT' => 'VT',
                        'VA' => 'VA',
                        'WA' => 'WA',
                        'WV' => 'WV',
                        'WI' => 'WI',
                        'WY' => 'WY',
                    ),
                    'default_value' => false,
                    'return_format' => 'value',
                    'multiple' => 0,
                    'allow_null' => 0,
                    'ui' => 0,
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_659713b9e93ba',
                    'label' => 'Zip',
                    'name' => 'location_zip',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'min' => 10000,
                    'max' => 99999,
                    'placeholder' => '',
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_659713e6e93bb',
                    'label' => 'Phone',
                    'name' => 'location_phone',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_659713ffe93bc',
                    'label' => 'Fax',
                    'name' => 'location_fax',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65971408e93bd',
                    'label' => 'Email',
                    'name' => 'location_email',
                    'aria-label' => '',
                    'type' => 'email',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'lionshead-settings',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'left',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);

    }

}