<?php
/**
 Plugin Name: Dojo Post Slider Widget for Elementor
 Description: This plugin lets you display your WordPress Posts as Carousel Slider.
 Author: Plugin Devs
 Author URI: https://letsgodojo.com/
 Version: 1.0
 License: GPLv2
 License URI: https://www.gnu.org/licenses/gpl-2.0.html
 Text Domain: dctheme
*/

 // Exit if accessed directly.
 if ( ! defined( 'ABSPATH' ) ) { exit; }

 /**
  * Main class
  */
class WB_POST_SLIDER
 {
 	
 	private static $instance;

	public static function getInstance() {
        if (!isset(self::$instance)) {
            self::$instance = new WB_POST_SLIDER();
            self::$instance->init();
        }
        return self::$instance;
    }

    //Empty Construct
 	function __construct(){}
 	
 	//initialize Plugin
 	public function init(){
 		$this->defined_constants();
 		$this->include_files();
		add_action( 'elementor/init', array( $this, 'wb_create_category') ); // Add a custom category for panel widgets
 	}

 	//Defined all constants for the plugin
 	public function defined_constants(){
 		define( 'WB_PS_MAIN_FILE', __FILE__ );
 		define( 'WB_PS_PATH', plugin_dir_path( __FILE__ ) );
		define( 'WB_PS_URL', plugin_dir_url( __FILE__ ) ) ;
		define( 'WB_PS_VERSION', '1.0' ) ; //Plugin Version
		define( 'WB_PS_MIN_ELEMENTOR_VERSION', '2.0.0' ) ; //MINIMUM ELEMENTOR Plugin Version
		define( 'WB_PS_MIN_PHP_VERSION', '5.4' ) ; //MINIMUM PHP Plugin Version
 	}

 	//Include all files
 	public function include_files(){

 		require_once( WB_PS_PATH . 'functions.php' );
 		require_once( WB_PS_PATH . 'admin/post-slider-utils.php' );
 	}

 	//Elementor new category register method
 	public function wb_create_category() {
	   \Elementor\Plugin::$instance->elements_manager->add_category( 
		   	'web-builder-element',
		   	[
		   		'title' => esc_html( 'Dojo Widget', 'dctheme' ),
		   		'icon' => 'fa fa-plug', //default icon
		   	],
		   	2 // position
	   );
	}

 	// prevent the instance from being cloned
    private function __clone(){}

    // prevent from being unserialized
    public function __wakeup(){}
 }

function wb_post_slider_register_function(){
	$wb_post_slider = WB_POST_SLIDER::getInstance();
}
add_action('plugins_loaded', 'wb_post_slider_register_function');


/**
 * Setup Plugin Activation Time
 *
 * @since 1.0.1
 *
 */
register_activation_hook(__FILE__,  'pdpcs_setup_plugin_activation_time' );
add_action('upgrader_process_complete', 'pdpcs_setup_plugin_activation_time');
add_action('init', 'pdpcs_setup_plugin_activation_time');
function pdpcs_setup_plugin_activation_time(){
	$installation_time = get_option('pdpcs_installed_time');
	if( !$installation_time ){
		update_option('pdpcs_installed_time', current_time('timestamp'));
	}
}