<?php
namespace Deployer;


desc('Create SSH Key');
task('stage-setup:sshkey', function () {

    if (test('[ -e ~/.ssh/id_rsa ]')) {
        writeln('<question>A SSH Encryption Key Exists!!</question>');
        if (!askConfirmation('Overwrite Existing Key?')) {
            writeln('Skipping Key Generation');
            return true;
        }
    }

    run('ssh-keygen -f ~/.ssh/id_rsa -N "" <<< Y');
});
