<?php
namespace Deployer;


desc('Add SSH Key to GitLab');
task('stage-setup:gitlab-deploykey', function() {

    $repo = get('repository');

    if (!$repo) {
        throw new Exception('Repository not Defined');
    }

    $repo = str_replace('git@gitlab.com:', 'https://gitlab.com/', $repo);
    $repo = str_replace('.git', '', $repo);

    $key = run('cat ~/.ssh/id_rsa.pub');
    writeln('<info>Add Public Key to Git</info>');
    writeln('<info>Git Repo:</info> <options=bold>'.$repo.'/-/settings/repository</>');
    writeln($key);
});
