<?php
namespace Deployer;

desc('Create Database');
task('stage-setup:create-database', function() {

    if (!SSHUSER) {
        throw new \Exception('SSH User Not Defined');
    }

    $word_list = file_get_contents('https://raw.githubusercontent.com/openethereum/wordlist/master/res/wordlist.txt');
    $word_array = explode(PHP_EOL, $word_list);
    $password_array = array_rand(array_flip($word_array), 4);
    $password_array = array_map('ucwords', $password_array);
    $password = implode('-', $password_array). random_int(0,9);

    run('uapi Mysql create_database name='.SSHUSER.'_live');
    run('uapi Mysql create_user name='.SSHUSER.'_wp password='.$password);
    run('uapi Mysql set_privileges_on_database database='.SSHUSER.'_live user='.SSHUSER.' privileges=ALL PRIVILEGES');

    writeln('DB_NAME='.SSHUSER.'_live');
    writeln('DB_USER='.SSHUSER.'_wp');
    writeln('DB_PASSWORD='.$password);
});
