<?php

use Tribe\Events\Filterbar\Views\V2\Filters\Context_Filter;
use Tribe__Utils__Array as Arr;

class Time_Of_Day_Custom extends \Tribe__Events__Filterbar__Filter {
	// Use the trait required for filters to correctly work with Views V2 code.
	use Context_Filter;

	public $type = 'checkbox';

	// These are needed to make the join aliases unique
	protected $alias = '';
	protected $tod_start_alias = '';
	protected $tod_duration_alias = '';

	protected function get_values() {

        $values = [];

        $terms = get_terms([
            'taxonomy'   => 'ages',
            'hide_empty' => false,
        ]);

        foreach ($terms as $term) {
            $values[] = [
                'name' => $term->name,
                'value' => $term->term_id
            ];
        }

        return $values;
	}

    /**
     * This method will only be called when the user has applied the filter (during the
     * tribe_events_pre_get_posts action) and sets up the taxonomy query, respecting any
     * other taxonomy queries that might already have been setup (whether by The Events
     * Calendar, another plugin or some custom code, etc).
     *
     * @see Tribe__Events__Filterbar__Filter::pre_get_posts()
     *
     * @param WP_Query $query
     */
    protected function pre_get_posts( WP_Query $query ) {
        $new_rules      = array();
        $existing_rules = (array) $query->get( 'tax_query' );
        $values         = (array) $this->currentValue;

        // if select display and event category has children get all those ids for query
        if ( 'select' === $this->type ) {

            $categories = get_categories(
                [
                    'taxonomy' => 'ages',
                    'child_of' => current( $values ),
                ]
            );

            if ( ! empty( $categories ) ) {
                foreach ( $categories as $category ) {
                    $values[] = $category->term_id;
                }
            }
        } elseif ( 'multiselect' === $this->type ) {
            // Any value that will evaluate to empty, we drop.
            $values = array_filter(Arr::list_to_array($values));
        }

        $new_rules[] = [
            'taxonomy' => 'ages',
            'operator' => 'IN',
            'terms'    => array_map( 'absint', $values ),
        ];

        /**
         * Controls the relationship between different taxonomy queries.
         *
         * If set to an empty value, then no attempt will be made by the additional field filter
         * to set the meta_query "relation" parameter.
         *
         * @var string $relation "AND"|"OR"
         */
        $relationship = apply_filters( 'tribe_events_filter_taxonomy_relationship', 'AND' );

        /**
         * If taxonomy filter meta queries should be nested and grouped together.
         *
         * The default is true in WordPress 4.1 and greater, which allows for greater flexibility
         * when combined with taxonomy queries added by other filters/other plugins.
         *
         * @var bool $group
         */
        $nest = apply_filters( 'tribe_events_filter_nest_taxonomy_queries', version_compare( $GLOBALS['wp_version'], '4.1', '>=' ) );

        if ( $nest ) {
            $new_rules = array(
                __CLASS__ => $new_rules,
            );
        }

        $tax_query = array_merge_recursive( $existing_rules, $new_rules );

        // Apply the relationship (we leave this late, or the recursive array merge would potentially cause duplicates)
        if ( ! empty( $relationship ) && $nest ) {
            $tax_query[ __CLASS__ ]['relation'] = $relationship;
        } elseif ( ! empty( $relationship ) ) {
            $tax_query['relation'] = $relationship;
        }

        // Apply our new meta query rules
        $query->set( 'tax_query', $tax_query );
    }
}
