<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Custom_Thumbnail_Slider_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'custom_thumbnail_slider';
    }

    public function get_title() {
        return __( 'Custom Thumbnail Slider', 'custom-elementor-widgets' );
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    public function get_script_depends() {
        return [ 'custom-thumbnail-slider-js' ];
    }

    public function get_style_depends() {
        return [ 'custom-thumbnail-slider-css' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'custom-elementor-widgets' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'custom-elementor-widgets' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'custom-elementor-widgets' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Slide Title', 'custom-elementor-widgets' ),
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => __( 'Eyebrow text', 'custom-elementor-widgets' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Slide eyebrow text', 'custom-elementor-widgets' ),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __( 'Link', 'custom-elementor-widgets' ),
                'type' => \Elementor\Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => __( 'Slides', 'custom-elementor-widgets' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __( 'Slide 1', 'custom-elementor-widgets' ),
                        'description' => __( 'Description for Slide 1', 'custom-elementor-widgets' ),
                        'image' => [ 'url' => \Elementor\Utils::get_placeholder_image_src() ],
                    ],
                    [
                        'title' => __( 'Slide 2', 'custom-elementor-widgets' ),
                        'description' => __( 'Description for Slide 2', 'custom-elementor-widgets' ),
                        'image' => [ 'url' => \Elementor\Utils::get_placeholder_image_src() ],
                    ],
                    [
                        'title' => __( 'Slide 3', 'custom-elementor-widgets' ),
                        'description' => __( 'Description for Slide 3', 'custom-elementor-widgets' ),
                        'image' => [ 'url' => \Elementor\Utils::get_placeholder_image_src() ],
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        // Main slider
        echo '<div class="rb-swiper">';
            echo '<div class="swiper-container main-slider">';
                echo '<div class="swiper-wrapper">';
                foreach ( $settings['slides'] as $slide ) {
                    echo '<div class="swiper-slide">';
                        echo '<div class="swiper-slide-bg" style="background-image:url(' . esc_url( $slide['image']['url'] ) . ')";></div>';
                        echo '<div class="swiper-slide-inner">';
                            if ( ! empty( $slide['link']['url'] ) ) {
                                $link_url = esc_url( $slide['link']['url'] );
                                $link_target = ! empty( $slide['link']['is_external'] ) ? ' target="_blank"' : '';
                                $link_rel = ! empty( $slide['link']['nofollow'] ) ? ' rel="nofollow"' : '';
                                echo '<a href="' . $link_url . '"' . $link_target . $link_rel . '>';
                            }
                                echo '<div class="swiper-slide-content">';
                                    echo '<p>' . esc_html( $slide['description'] ) . '</p>';
                                    echo '<h3>' . esc_html( $slide['title'] ) . '</h3>';
                                echo '</div>';
                            if ( ! empty( $slide['link']['url'] ) ) { echo '</a>'; }
                        echo '</div>';
                    echo '</div>';
                }
                    
                echo '</div>';
                echo '<div class="swiper-button-prev"></div>';
                echo '<div class="swiper-button-next"></div>';
            echo '</div>';
        

            // Thumbnail slider
            echo '<div class="swiper-container thumbnail-slider">';
                echo '<div class="swiper-wrapper">';
                foreach ( $settings['slides'] as $slide ) {
                    $medium_image_url = wp_get_attachment_image_src( $slide['image']['id'], 'medium' )[0];
                    echo '<div class="swiper-slide">';
                        echo '<div class="slide-bg" style="background-image:url(' . esc_url( $medium_image_url ) . ')" ></div>';
                        echo '<div class="slide-content">';
                            echo '<h3>' . esc_html( $slide['title'] ) . '</h3>';
                        echo '</div>';
                    echo '</div>';
                }
                echo '</div>';
            echo '</div>';
        echo '</div>';
        
    }

    protected function _content_template() {
        ?>
        <# if ( settings.slides.length ) { #>
            <div class="swiper-container main-slider">
                <div class="swiper-wrapper">
                    <# _.each( settings.slides, function( slide ) { #>
                        <div class="swiper-slide">
                            <div class="swiper-slide-bg" style="background-image:url({{ slide.image.url }});"></div>
                            <div class="swiper-slide-inner">
                                <div class="swiper-slide-content">
                                    <p>{{{ slide.description }}}</p>
                                    <h3>{{{ slide.title }}}</h3>
                                </div>
                            </div>
                        </div>
                    <# } ); #>
                </div>
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
            </div>
        <# } #>
        <?php
    }
}
